"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerChartInfoTooltip = void 0;
require("./_explorer_chart_tooltip.scss");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _explorer_constants = require("../explorer_constants");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHART_DESCRIPTION = {
  [_explorer_constants.CHART_TYPE.EVENT_DISTRIBUTION]: _i18n.i18n.translate('xpack.ml.explorer.charts.infoTooltip.chartEventDistributionDescription', {
    defaultMessage: 'The gray dots depict the approximate distribution of occurrences over time for a sample of {byFieldValuesParam} with' + ' more frequent event types at the top and rarer ones at the bottom.',
    values: {
      byFieldValuesParam: 'by_field_values'
    }
  }),
  [_explorer_constants.CHART_TYPE.POPULATION_DISTRIBUTION]: _i18n.i18n.translate('xpack.ml.explorer.charts.infoTooltip.chartPopulationDistributionDescription', {
    defaultMessage: 'The gray dots depict the approximate distribution of values over time for a sample of {overFieldValuesParam}.',
    values: {
      overFieldValuesParam: 'over_field_values'
    }
  })
};
function TooltipDefinitionList({
  toolTipData
}) {
  return /*#__PURE__*/_react.default.createElement("dl", {
    className: "mlDescriptionList"
  }, toolTipData.map(({
    title,
    description
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: `${title} ${description}`
  }, /*#__PURE__*/_react.default.createElement("dt", {
    className: "mlDescriptionList__title"
  }, title), /*#__PURE__*/_react.default.createElement("dd", {
    className: "mlDescriptionList__description"
  }, description))));
}
const ExplorerChartInfoTooltip = ({
  jobId,
  aggregationInterval,
  chartFunction,
  chartType,
  entityFields = []
}) => {
  const chartDescription = CHART_DESCRIPTION[chartType];
  const toolTipData = [{
    title: _i18n.i18n.translate('xpack.ml.explorer.charts.infoTooltip.jobIdTitle', {
      defaultMessage: 'job ID'
    }),
    description: jobId
  }, {
    title: _i18n.i18n.translate('xpack.ml.explorer.charts.infoTooltip.aggregationIntervalTitle', {
      defaultMessage: 'aggregation interval'
    }),
    description: aggregationInterval
  }, {
    title: _i18n.i18n.translate('xpack.ml.explorer.charts.infoTooltip.chartFunctionTitle', {
      defaultMessage: 'chart function'
    }),
    description: chartFunction
  }];
  entityFields.forEach(entityField => {
    toolTipData.push({
      title: entityField.fieldName,
      description: entityField.fieldValue
    });
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "ml-explorer-chart-info-tooltip"
  }, /*#__PURE__*/_react.default.createElement(TooltipDefinitionList, {
    toolTipData: toolTipData
  }), chartDescription && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "ml-explorer-chart-description"
  }, chartDescription)));
};
exports.ExplorerChartInfoTooltip = ExplorerChartInfoTooltip;
ExplorerChartInfoTooltip.propTypes = {
  jobId: _propTypes.default.string.isRequired,
  aggregationInterval: _propTypes.default.string,
  chartFunction: _propTypes.default.string,
  entityFields: _propTypes.default.array
};