"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyTimelineStateService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _explorer_constants = require("./explorer_constants");
var _job_service = require("../services/job_service");
var _explorer_utils = require("./explorer_utils");
var _state_service = require("../services/state_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// FIXME get rid of the static import

// FIXME get rid of the static import

/**
 * Service for managing anomaly timeline state.
 */
class AnomalyTimelineStateService extends _state_service.StateService {
  constructor(anomalyExplorerUrlStateService, anomalyExplorerCommonStateService, anomalyTimelineService, timefilter) {
    super();
    // TODO: Add services for getSelectionInfluencers, getSelectionJobIds, & getSelectionTimeRange
    // to consolidate usage
    (0, _defineProperty2.default)(this, "_explorerURLStateCallback", void 0);
    (0, _defineProperty2.default)(this, "_overallSwimLaneData$", new _rxjs.BehaviorSubject(null));
    (0, _defineProperty2.default)(this, "_viewBySwimLaneData$", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "_swimLaneUrlState$", new _rxjs.BehaviorSubject(null));
    (0, _defineProperty2.default)(this, "_containerWidth$", new _rxjs.BehaviorSubject(0));
    (0, _defineProperty2.default)(this, "_selectedCells$", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "_swimLaneSeverity$", new _rxjs.BehaviorSubject(0));
    (0, _defineProperty2.default)(this, "_swimLanePagination$", new _rxjs.BehaviorSubject({
      viewByFromPage: 1,
      viewByPerPage: 10
    }));
    (0, _defineProperty2.default)(this, "_swimLaneCardinality$", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "_viewBySwimlaneFieldName$", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "_viewBySwimLaneOptions$", new _rxjs.BehaviorSubject([]));
    (0, _defineProperty2.default)(this, "_topFieldValues$", new _rxjs.BehaviorSubject([]));
    (0, _defineProperty2.default)(this, "_isOverallSwimLaneLoading$", new _rxjs.BehaviorSubject(true));
    (0, _defineProperty2.default)(this, "_isViewBySwimLaneLoading$", new _rxjs.BehaviorSubject(true));
    (0, _defineProperty2.default)(this, "_swimLaneBucketInterval$", new _rxjs.BehaviorSubject(null));
    (0, _defineProperty2.default)(this, "_timeBounds$", void 0);
    (0, _defineProperty2.default)(this, "_refreshSubject$", void 0);
    /** Time domain of the currently active swim lane */
    (0, _defineProperty2.default)(this, "timeDomain$", this._overallSwimLaneData$.pipe((0, _rxjs.map)(data => {
      if (!data) return null;
      return {
        min: data.earliest * 1000,
        max: data.latest * 1000,
        minInterval: data.interval * 1000
      };
    })));
    this.anomalyExplorerUrlStateService = anomalyExplorerUrlStateService;
    this.anomalyExplorerCommonStateService = anomalyExplorerCommonStateService;
    this.anomalyTimelineService = anomalyTimelineService;
    this.timefilter = timefilter;
    this._timeBounds$ = this.timefilter.getTimeUpdate$().pipe((0, _rxjs.startWith)(null), (0, _rxjs.map)(() => this.timefilter.getBounds()));
    this._refreshSubject$ = _mlDatePicker.mlTimefilterRefresh$.pipe((0, _rxjs.startWith)({
      lastRefresh: 0
    }));
    this._explorerURLStateCallback = (update, replaceState) => {
      const explorerUrlState = this.anomalyExplorerUrlStateService.getPageUrlState();
      const mlExplorerSwimLaneState = explorerUrlState === null || explorerUrlState === void 0 ? void 0 : explorerUrlState.mlExplorerSwimlane;
      const resultUpdate = replaceState ? update : {
        ...mlExplorerSwimLaneState,
        ...update
      };
      return this.anomalyExplorerUrlStateService.updateUrlState({
        ...explorerUrlState,
        mlExplorerSwimlane: resultUpdate
      });
    };
    this._init();
  }

  /**
   * Initializes required subscriptions for fetching swim lanes data.
   * @private
   */
  _initSubscriptions() {
    const subscription = new _rxjs.Subscription();
    subscription.add(this.anomalyExplorerUrlStateService.getPageUrlState$().pipe((0, _rxjs.map)(v => v === null || v === void 0 ? void 0 : v.mlExplorerSwimlane), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual)).subscribe(this._swimLaneUrlState$));
    subscription.add(this._initViewByData());
    subscription.add(this._swimLaneUrlState$.pipe((0, _rxjs.map)(v => {
      var _v$severity;
      return (_v$severity = v === null || v === void 0 ? void 0 : v.severity) !== null && _v$severity !== void 0 ? _v$severity : 0;
    }), (0, _rxjs.distinctUntilChanged)()).subscribe(this._swimLaneSeverity$));
    subscription.add(this._initSwimLanePagination());
    subscription.add(this._initOverallSwimLaneData());
    subscription.add(this._initTopFieldValues());
    subscription.add(this._initViewBySwimLaneData());
    subscription.add((0, _rxjs.combineLatest)([this.anomalyExplorerCommonStateService.getSelectedJobs$(), this.getContainerWidth$(), this._timeBounds$]).subscribe(([selectedJobs, containerWidth]) => {
      this._swimLaneBucketInterval$.next(this.anomalyTimelineService.getSwimlaneBucketInterval(selectedJobs, containerWidth));
    }));
    subscription.add(this._initSelectedCells());
    return subscription;
  }
  _initViewByData() {
    return (0, _rxjs.combineLatest)([this._swimLaneUrlState$.pipe((0, _rxjs.map)(v => v === null || v === void 0 ? void 0 : v.viewByFieldName), (0, _rxjs.distinctUntilChanged)()), this.anomalyExplorerCommonStateService.getSelectedJobs$(), this.anomalyExplorerCommonStateService.getFilterSettings$(), this._selectedCells$]).subscribe(([currentlySelected, selectedJobs, filterSettings, selectedCells]) => {
      const {
        viewBySwimlaneFieldName,
        viewBySwimlaneOptions
      } = this._getViewBySwimlaneOptions(currentlySelected, filterSettings.filterActive, filterSettings.filteredFields, false, selectedCells, selectedJobs);
      this._viewBySwimlaneFieldName$.next(viewBySwimlaneFieldName);
      this._viewBySwimLaneOptions$.next(viewBySwimlaneOptions);
    });
  }
  _initSwimLanePagination() {
    return (0, _rxjs.combineLatest)([this._swimLaneUrlState$.pipe((0, _rxjs.map)(v => {
      var _v$viewByFromPage, _v$viewByPerPage;
      return {
        viewByFromPage: (_v$viewByFromPage = v === null || v === void 0 ? void 0 : v.viewByFromPage) !== null && _v$viewByFromPage !== void 0 ? _v$viewByFromPage : 1,
        viewByPerPage: (_v$viewByPerPage = v === null || v === void 0 ? void 0 : v.viewByPerPage) !== null && _v$viewByPerPage !== void 0 ? _v$viewByPerPage : 10
      };
    }), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual)), this.anomalyExplorerCommonStateService.getInfluencerFilterQuery$(), this._timeBounds$]).subscribe(([pagination, influencersFilerQuery]) => {
      let resultPaginaiton = pagination;
      if (influencersFilerQuery) {
        resultPaginaiton = {
          viewByPerPage: pagination.viewByPerPage,
          viewByFromPage: 1
        };
      }
      this._swimLanePagination$.next(resultPaginaiton);
    });
  }
  _initOverallSwimLaneData() {
    return (0, _rxjs.combineLatest)([this.anomalyExplorerCommonStateService.getSelectedJobs$(), this._swimLaneSeverity$, this.getSwimLaneBucketInterval$(), this._timeBounds$, this._refreshSubject$]).pipe((0, _rxjs.tap)(() => {
      this._isOverallSwimLaneLoading$.next(true);
    }), (0, _rxjs.switchMap)(([selectedJobs, severity, bucketInterval]) => {
      return (0, _rxjs.from)(this.anomalyTimelineService.loadOverallData(selectedJobs, undefined, bucketInterval, severity));
    })).subscribe(v => {
      this._overallSwimLaneData$.next(v);
      this._isOverallSwimLaneLoading$.next(false);
    });
  }
  _initTopFieldValues() {
    return (0, _rxjs.combineLatest)([this.anomalyExplorerCommonStateService.getSelectedJobs$(), this.anomalyExplorerCommonStateService.getInfluencerFilterQuery$(), this.getViewBySwimlaneFieldName$(), this.getSwimLanePagination$(), this.getSwimLaneCardinality$(), this.getSelectedCells$(), this.getSwimLaneBucketInterval$(), this._timeBounds$, this._refreshSubject$]).pipe((0, _rxjs.switchMap)(([selectedJobs, influencersFilterQuery, viewBySwimlaneFieldName, swimLanePagination, swimLaneCardinality, selectedCells, swimLaneBucketInterval]) => {
      if (!(selectedCells !== null && selectedCells !== void 0 && selectedCells.showTopFieldValues)) {
        return (0, _rxjs.of)([]);
      }
      const selectionInfluencers = (0, _explorer_utils.getSelectionInfluencers)(selectedCells, viewBySwimlaneFieldName);
      const timerange = (0, _explorer_utils.getSelectionTimeRange)(selectedCells, this.timefilter.getBounds());
      return (0, _rxjs.from)(this.anomalyTimelineService.loadViewByTopFieldValuesForSelectedTime(timerange.earliestMs, timerange.latestMs, selectedJobs, viewBySwimlaneFieldName, _explorer_constants.ANOMALY_SWIM_LANE_HARD_LIMIT, swimLanePagination.viewByPerPage, swimLanePagination.viewByFromPage, swimLaneBucketInterval, selectionInfluencers, influencersFilterQuery));
    })).subscribe(this._topFieldValues$);
  }
  _initViewBySwimLaneData() {
    return (0, _rxjs.combineLatest)([this._overallSwimLaneData$.pipe((0, _rxjs.skipWhile)(v => !v)), this.anomalyExplorerCommonStateService.getSelectedJobs$(), this.anomalyExplorerCommonStateService.getInfluencerFilterQuery$(), this._swimLaneSeverity$, this.getSwimLaneBucketInterval$(), this.getViewBySwimlaneFieldName$(), this.getSwimLanePagination$(), this._topFieldValues$.pipe((0, _rxjs.distinctUntilChanged)(_lodash.isEqual)), this._timeBounds$, this._refreshSubject$]).pipe((0, _rxjs.tap)(() => {
      this._isViewBySwimLaneLoading$.next(true);
    }), (0, _rxjs.switchMap)(([overallSwimLaneData, selectedJobs, influencersFilterQuery, severity, bucketInterval, viewBySwimlaneFieldName, swimLanePagination, topFieldValues]) => {
      return (0, _rxjs.from)(this.anomalyTimelineService.loadViewBySwimlane(topFieldValues, {
        earliest: overallSwimLaneData.earliest,
        latest: overallSwimLaneData.latest
      }, selectedJobs, viewBySwimlaneFieldName, _explorer_constants.ANOMALY_SWIM_LANE_HARD_LIMIT, swimLanePagination.viewByPerPage, swimLanePagination.viewByFromPage, undefined, influencersFilterQuery, bucketInterval, severity));
    })).subscribe(v => {
      this._viewBySwimLaneData$.next(v);
      this._isViewBySwimLaneLoading$.next(false);
      this._swimLaneCardinality$.next(v === null || v === void 0 ? void 0 : v.cardinality);
    });
  }
  _initSelectedCells() {
    return (0, _rxjs.combineLatest)([this._viewBySwimlaneFieldName$, this._swimLaneUrlState$, this.getSwimLaneBucketInterval$(), this._timeBounds$]).pipe((0, _rxjs.map)(([viewByFieldName, swimLaneUrlState, swimLaneBucketInterval]) => {
      var _swimLaneUrlState$sel, _swimLaneUrlState$sel2;
      if (!(swimLaneUrlState !== null && swimLaneUrlState !== void 0 && swimLaneUrlState.selectedType)) {
        return null;
      }
      let times = (_swimLaneUrlState$sel = swimLaneUrlState.selectedTimes) !== null && _swimLaneUrlState$sel !== void 0 ? _swimLaneUrlState$sel : swimLaneUrlState.selectedTime;
      if (typeof times === 'number') {
        times = [times, times + swimLaneBucketInterval.asSeconds()];
      }
      let lanes = (_swimLaneUrlState$sel2 = swimLaneUrlState.selectedLanes) !== null && _swimLaneUrlState$sel2 !== void 0 ? _swimLaneUrlState$sel2 : swimLaneUrlState.selectedLane;
      if (typeof lanes === 'string') {
        lanes = [lanes];
      }
      times = this._getAdjustedTimeSelection(times, this.timefilter.getBounds());
      if (!times) {
        return null;
      }
      return {
        type: swimLaneUrlState.selectedType,
        lanes,
        times,
        showTopFieldValues: swimLaneUrlState.showTopFieldValues,
        viewByFieldName
      };
    }), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual)).subscribe(this._selectedCells$);
  }

  /**
   * Adjust cell selection with respect to the time boundaries.
   * @return adjusted time selection or undefined if out of current range entirely.
   */
  _getAdjustedTimeSelection(times, timeBounds) {
    const [selectedFrom, selectedTo] = times;

    /**
     * Because each cell on the swim lane represent the fixed bucket interval,
     * the selection range could be out of the time boundaries with
     * correction within the bucket interval.
     */
    const bucketSpanInterval = this.getSwimLaneBucketInterval().asSeconds();
    const rangeFrom = timeBounds.min.unix() - bucketSpanInterval;
    const rangeTo = timeBounds.max.unix() + bucketSpanInterval;
    const resultFrom = Math.max(selectedFrom, rangeFrom);
    const resultTo = Math.min(selectedTo, rangeTo);
    const isSelectionOutOfRange = rangeFrom > resultTo || rangeTo < resultFrom;
    if (isSelectionOutOfRange) {
      // reset selection
      return;
    }
    if (selectedFrom === resultFrom && selectedTo === resultTo) {
      // selection is correct, no need to adjust the range
      return times;
    }
    if (resultFrom !== rangeFrom || resultTo !== rangeTo) {
      return [resultFrom, resultTo];
    }
  }

  /**
   * Obtain the list of 'View by' fields per job and viewBySwimlaneFieldName
   * @private
   *
   * TODO check for possible enhancements/refactoring. Has been moved from explorer_utils as-is.
   */
  _getViewBySwimlaneOptions(currentViewBySwimlaneFieldName, filterActive, filteredFields, isAndOperator, selectedCells, selectedJobs) {
    var _selectedJobs$map;
    const selectedJobIds = (_selectedJobs$map = selectedJobs === null || selectedJobs === void 0 ? void 0 : selectedJobs.map(d => d.id)) !== null && _selectedJobs$map !== void 0 ? _selectedJobs$map : [];

    // Unique influencers for the selected job(s).
    const viewByOptions = (0, _lodash.sortBy)((0, _lodash.uniq)(_job_service.mlJobService.jobs.reduce((reducedViewByOptions, job) => {
      if (selectedJobIds.some(jobId => jobId === job.job_id)) {
        return reducedViewByOptions.concat(job.analysis_config.influencers || []);
      }
      return reducedViewByOptions;
    }, [])), fieldName => fieldName.toLowerCase());
    viewByOptions.push(_explorer_constants.VIEW_BY_JOB_LABEL);
    let viewBySwimlaneOptions = viewByOptions;
    let viewBySwimlaneFieldName;
    if (viewBySwimlaneOptions.indexOf(currentViewBySwimlaneFieldName) !== -1) {
      // Set the swim lane viewBy to that stored in the state (URL) if set.
      // This means we reset it to the current state because it was set by the listener
      // on initialization.
      viewBySwimlaneFieldName = currentViewBySwimlaneFieldName;
    } else {
      if (selectedJobIds.length > 1) {
        // If more than one job selected, default to job ID.
        viewBySwimlaneFieldName = _explorer_constants.VIEW_BY_JOB_LABEL;
      } else if (_job_service.mlJobService.jobs.length > 0 && selectedJobIds.length > 0) {
        var _firstSelectedJob$ana;
        // For a single job, default to the first partition, over,
        // by or influencer field of the first selected job.
        const firstSelectedJob = _job_service.mlJobService.jobs.find(job => {
          return job.job_id === selectedJobIds[0];
        });
        const firstJobInfluencers = (_firstSelectedJob$ana = firstSelectedJob === null || firstSelectedJob === void 0 ? void 0 : firstSelectedJob.analysis_config.influencers) !== null && _firstSelectedJob$ana !== void 0 ? _firstSelectedJob$ana : [];
        firstSelectedJob === null || firstSelectedJob === void 0 ? void 0 : firstSelectedJob.analysis_config.detectors.forEach(detector => {
          if (detector.partition_field_name !== undefined && firstJobInfluencers.indexOf(detector.partition_field_name) !== -1) {
            viewBySwimlaneFieldName = detector.partition_field_name;
            return false;
          }
          if (detector.over_field_name !== undefined && firstJobInfluencers.indexOf(detector.over_field_name) !== -1) {
            viewBySwimlaneFieldName = detector.over_field_name;
            return false;
          }

          // For jobs with by and over fields, don't add the 'by' field as this
          // field will only be added to the top-level fields for record type results
          // if it also an influencer over the bucket.
          if (detector.by_field_name !== undefined && detector.over_field_name === undefined && firstJobInfluencers.indexOf(detector.by_field_name) !== -1) {
            viewBySwimlaneFieldName = detector.by_field_name;
            return false;
          }
        });
        if (viewBySwimlaneFieldName === undefined) {
          if (firstJobInfluencers.length > 0) {
            viewBySwimlaneFieldName = firstJobInfluencers[0];
          } else {
            // No influencers for first selected job - set to first available option.
            viewBySwimlaneFieldName = viewBySwimlaneOptions.length > 0 ? viewBySwimlaneOptions[0] : undefined;
          }
        }
      }
    }

    // filter View by options to relevant filter fields
    // If it's an AND filter only show job Id view by as the rest will have no results
    if (filterActive === true && isAndOperator === true && !selectedCells) {
      viewBySwimlaneOptions = [_explorer_constants.VIEW_BY_JOB_LABEL];
    } else if (filterActive === true && Array.isArray(viewBySwimlaneOptions) && Array.isArray(filteredFields)) {
      const filteredOptions = viewBySwimlaneOptions.filter(option => {
        return filteredFields.includes(option) || option === _explorer_constants.VIEW_BY_JOB_LABEL || selectedCells && selectedCells.viewByFieldName === option;
      });
      // only replace viewBySwimlaneOptions with filteredOptions if we found a relevant matching field
      if (filteredOptions.length > 1) {
        viewBySwimlaneOptions = filteredOptions;
        if (!viewBySwimlaneOptions.includes(viewBySwimlaneFieldName)) {
          viewBySwimlaneFieldName = viewBySwimlaneOptions[0];
        }
      }
    }
    return {
      viewBySwimlaneFieldName,
      viewBySwimlaneOptions
    };
  }

  /**
   * Provides overall swim lane data.
   */
  getOverallSwimLaneData$() {
    return this._overallSwimLaneData$.asObservable();
  }
  getViewBySwimLaneData$() {
    return this._viewBySwimLaneData$.asObservable();
  }
  getContainerWidth$() {
    return this._containerWidth$.pipe((0, _rxjs.debounceTime)(500), (0, _rxjs.distinctUntilChanged)((prev, curr) => {
      const delta = Math.abs(prev - curr);
      // Scrollbar appears during the page rendering,
      // it causes small width change that we want to ignore.
      return delta < 20;
    }));
  }
  getContainerWidth() {
    return this._containerWidth$.getValue();
  }

  /**
   * Provides updates for swim lanes cells selection.
   */
  getSelectedCells$() {
    return this._selectedCells$.asObservable();
  }
  getSelectedCells() {
    return this._selectedCells$.getValue();
  }
  getSwimLaneSeverity$() {
    return this._swimLaneSeverity$.asObservable();
  }
  getSwimLaneSeverity() {
    return this._swimLaneSeverity$.getValue();
  }
  getSwimLanePagination$() {
    return this._swimLanePagination$.asObservable();
  }
  getSwimLanePagination() {
    return this._swimLanePagination$.getValue();
  }
  setSwimLanePagination(update) {
    const resultUpdate = update;
    if (resultUpdate.viewByPerPage) {
      resultUpdate.viewByFromPage = 1;
    }
    this._explorerURLStateCallback(resultUpdate);
  }
  getSwimLaneCardinality$() {
    return this._swimLaneCardinality$.pipe((0, _rxjs.distinctUntilChanged)());
  }
  getViewBySwimlaneFieldName$() {
    return this._viewBySwimlaneFieldName$.pipe((0, _rxjs.distinctUntilChanged)());
  }
  getViewBySwimLaneOptions$() {
    return this._viewBySwimLaneOptions$.asObservable();
  }

  /**
   * Currently selected jobs on the swim lane
   */
  getSwimLaneJobs$() {
    return (0, _rxjs.combineLatest)([this.anomalyExplorerCommonStateService.getSelectedJobs$(), this.getViewBySwimlaneFieldName$(), this._viewBySwimLaneData$, this._selectedCells$]).pipe((0, _rxjs.map)(([selectedJobs, swimLaneFieldName, viewBySwimLaneData, selectedCells]) => {
      // If there are selected lanes on the view by swim lane, use those to filter the jobs.
      if ((selectedCells === null || selectedCells === void 0 ? void 0 : selectedCells.type) === _explorer_constants.SWIMLANE_TYPE.VIEW_BY && (selectedCells === null || selectedCells === void 0 ? void 0 : selectedCells.viewByFieldName) === _explorer_constants.VIEW_BY_JOB_LABEL) {
        return selectedJobs.filter(job => {
          return selectedCells.lanes.includes(job.id);
        });
      }
      if ((selectedCells === null || selectedCells === void 0 ? void 0 : selectedCells.type) === _explorer_constants.SWIMLANE_TYPE.OVERALL && (selectedCells === null || selectedCells === void 0 ? void 0 : selectedCells.viewByFieldName) === _explorer_constants.VIEW_BY_JOB_LABEL && viewBySwimLaneData) {
        return selectedJobs.filter(job => {
          return viewBySwimLaneData.laneLabels.includes(job.id);
        });
      }
      return selectedJobs;
    }));
  }
  getViewBySwimLaneOptions() {
    return this._viewBySwimLaneOptions$.getValue();
  }
  isOverallSwimLaneLoading$() {
    return this._isOverallSwimLaneLoading$.asObservable();
  }
  isViewBySwimLaneLoading$() {
    return this._isViewBySwimLaneLoading$.asObservable();
  }

  /**
   * Sets container width
   * @param value
   */
  setContainerWidth(value) {
    this._containerWidth$.next(value);
  }

  /**
   * Sets swim lanes severity.
   * Updates the URL state.
   * @param value
   */
  setSeverity(value) {
    this._explorerURLStateCallback({
      severity: value,
      viewByFromPage: 1
    });
  }

  /**
   * Sets selected cells.
   * @param swimLaneSelectedCells
   */
  setSelectedCells(swimLaneSelectedCells) {
    const vall = this._swimLaneUrlState$.getValue();
    const mlExplorerSwimlane = {
      ...vall
    };
    if (swimLaneSelectedCells !== undefined) {
      var _this$_selectedCells$, _this$_selectedCells$2;
      swimLaneSelectedCells.showTopFieldValues = false;
      const currentSwimlaneType = (_this$_selectedCells$ = this._selectedCells$.getValue()) === null || _this$_selectedCells$ === void 0 ? void 0 : _this$_selectedCells$.type;
      const currentShowTopFieldValues = (_this$_selectedCells$2 = this._selectedCells$.getValue()) === null || _this$_selectedCells$2 === void 0 ? void 0 : _this$_selectedCells$2.showTopFieldValues;
      const newSwimlaneType = swimLaneSelectedCells === null || swimLaneSelectedCells === void 0 ? void 0 : swimLaneSelectedCells.type;
      if (currentSwimlaneType === _explorer_constants.SWIMLANE_TYPE.OVERALL && newSwimlaneType === _explorer_constants.SWIMLANE_TYPE.VIEW_BY || newSwimlaneType === _explorer_constants.SWIMLANE_TYPE.OVERALL || currentShowTopFieldValues === true) {
        swimLaneSelectedCells.showTopFieldValues = true;
      }
      mlExplorerSwimlane.selectedType = swimLaneSelectedCells.type;
      mlExplorerSwimlane.selectedLanes = swimLaneSelectedCells.lanes;
      mlExplorerSwimlane.selectedTimes = swimLaneSelectedCells.times;
      mlExplorerSwimlane.showTopFieldValues = swimLaneSelectedCells.showTopFieldValues;
      this._explorerURLStateCallback(mlExplorerSwimlane);
    } else {
      delete mlExplorerSwimlane.selectedType;
      delete mlExplorerSwimlane.selectedLanes;
      delete mlExplorerSwimlane.selectedTimes;
      delete mlExplorerSwimlane.showTopFieldValues;
      this._explorerURLStateCallback(mlExplorerSwimlane, true);
    }
  }

  /**
   * Updates View by swim lane value.
   * @param fieldName - Influencer field name of job id.
   */
  setViewBySwimLaneFieldName(fieldName) {
    this._explorerURLStateCallback({
      viewByFromPage: 1,
      viewByPerPage: this._swimLanePagination$.getValue().viewByPerPage,
      viewByFieldName: fieldName
    }, true);
  }
  getSwimLaneBucketInterval$() {
    return this._swimLaneBucketInterval$.pipe((0, _rxjs.filter)(v => !!v), (0, _rxjs.distinctUntilChanged)((prev, curr) => {
      return prev.asSeconds() === curr.asSeconds();
    }));
  }
  getSwimLaneBucketInterval() {
    return this._swimLaneBucketInterval$.getValue();
  }
}
exports.AnomalyTimelineStateService = AnomalyTimelineStateService;