"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyExplorerContextProvider = exports.AnomalyExplorerContext = void 0;
exports.useAnomalyExplorerContext = useAnomalyExplorerContext;
var _react = _interopRequireWildcard(require("react"));
var _mlDatePicker = require("@kbn/ml-date-picker");
var _anomaly_timeline_state_service = require("./anomaly_timeline_state_service");
var _anomaly_explorer_common_state = require("./anomaly_explorer_common_state");
var _kibana = require("../contexts/kibana");
var _results_service = require("../services/results_service");
var _anomaly_timeline_service = require("../services/anomaly_timeline_service");
var _use_explorer_url_state = require("./hooks/use_explorer_url_state");
var _anomaly_charts_state_service = require("./anomaly_charts_state_service");
var _anomaly_explorer_charts_service = require("../services/anomaly_explorer_charts_service");
var _select_severity = require("../components/controls/select_severity");
var _alerts = require("./alerts");
var _explorer_dashboard_service = require("./explorer_dashboard_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Context of the Anomaly Explorer page.
 */
const AnomalyExplorerContext = exports.AnomalyExplorerContext = /*#__PURE__*/_react.default.createContext(undefined);

/**
 * Hook for consuming {@link AnomalyExplorerContext}.
 */
function useAnomalyExplorerContext() {
  const context = (0, _react.useContext)(AnomalyExplorerContext);
  if (context === undefined) {
    throw new Error('AnomalyExplorerContext has not been initialized.');
  }
  return context;
}

/**
 * Anomaly Explorer Context Provider.
 */
const AnomalyExplorerContextProvider = ({
  children
}) => {
  const [,, anomalyExplorerUrlStateService] = (0, _use_explorer_url_state.useExplorerUrlState)();
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const {
    services: {
      mlServices: {
        mlApiServices,
        mlFieldFormatService
      },
      uiSettings,
      data
    }
  } = (0, _kibana.useMlKibana)();
  const [,, tableSeverityState] = (0, _select_severity.useTableSeverity)();

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const mlResultsService = (0, _react.useMemo)(() => (0, _results_service.mlResultsServiceProvider)(mlApiServices), []);
  const [anomalyExplorerContextValue, setAnomalyExplorerContextValue] = (0, _react.useState)(undefined);

  // It might look tempting to refactor this into `useMemo()` and just return
  // `anomalyExplorerContextValue`, but these services internally might call other state
  // updates so using `useEffect` is the right thing to do here to not get errors
  // related to React lifecycle methods.
  (0, _react.useEffect)(() => {
    const explorerService = (0, _explorer_dashboard_service.explorerServiceFactory)(mlFieldFormatService);
    const anomalyTimelineService = new _anomaly_timeline_service.AnomalyTimelineService(timefilter, uiSettings, mlResultsService);
    const anomalyExplorerCommonStateService = new _anomaly_explorer_common_state.AnomalyExplorerCommonStateService(anomalyExplorerUrlStateService);
    const anomalyTimelineStateService = new _anomaly_timeline_state_service.AnomalyTimelineStateService(anomalyExplorerUrlStateService, anomalyExplorerCommonStateService, anomalyTimelineService, timefilter);
    const anomalyExplorerChartsService = new _anomaly_explorer_charts_service.AnomalyExplorerChartsService(timefilter, mlApiServices, mlResultsService);
    const chartsStateService = new _anomaly_charts_state_service.AnomalyChartsStateService(anomalyExplorerCommonStateService, anomalyTimelineStateService, anomalyExplorerChartsService, anomalyExplorerUrlStateService, tableSeverityState);
    const anomalyDetectionAlertsStateService = new _alerts.AnomalyDetectionAlertsStateService(anomalyTimelineStateService, data, timefilter);
    setAnomalyExplorerContextValue({
      anomalyExplorerChartsService,
      anomalyExplorerCommonStateService,
      anomalyTimelineService,
      anomalyTimelineStateService,
      chartsStateService,
      anomalyDetectionAlertsStateService,
      explorerService
    });
    return () => {
      // upon component unmounting
      // clear any data to prevent next page from rendering old charts
      anomalyExplorerCommonStateService.destroy();
      anomalyTimelineStateService.destroy();
      chartsStateService.destroy();
      anomalyDetectionAlertsStateService.destroy();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  if (anomalyExplorerContextValue === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(AnomalyExplorerContext.Provider, {
    value: anomalyExplorerContextValue
  }, children);
};
exports.AnomalyExplorerContextProvider = AnomalyExplorerContextProvider;