"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataLoader = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _ml_api_service = require("../../../services/ml_api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Maximum number of examples to obtain for text type fields.
const MAX_EXAMPLES_DEFAULT = 10;
class DataLoader {
  constructor(indexPattern, toastNotifications) {
    (0, _defineProperty2.default)(this, "_indexPattern", void 0);
    (0, _defineProperty2.default)(this, "_runtimeMappings", void 0);
    (0, _defineProperty2.default)(this, "_indexPatternTitle", '');
    (0, _defineProperty2.default)(this, "_maxExamples", MAX_EXAMPLES_DEFAULT);
    this._indexPattern = indexPattern;
    this._runtimeMappings = this._indexPattern.getComputedFields().runtimeFields;
    this._indexPatternTitle = indexPattern.title;
  }
  async loadFieldHistograms(fields, query, samplerShardSize = _mlAggUtils.DEFAULT_SAMPLER_SHARD_SIZE, editorRuntimeMappings) {
    const stats = await _ml_api_service.ml.getVisualizerFieldHistograms({
      indexPattern: this._indexPatternTitle,
      query,
      fields,
      samplerShardSize,
      runtimeMappings: editorRuntimeMappings || this._runtimeMappings
    });
    return stats;
  }
  set maxExamples(max) {
    this._maxExamples = max;
  }
  get maxExamples() {
    return this._maxExamples;
  }

  // Returns whether the field with the specified name should be displayed,
  // as certain fields such as _id and _source should be omitted from the view.
  isDisplayField(fieldName) {
    return !_mlAnomalyUtils.OMIT_FIELDS.includes(fieldName);
  }
}
exports.DataLoader = DataLoader;