"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileDataVisualizerPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _help_menu = require("../../components/help_menu");
var _kibana = require("../../contexts/kibana");
var _locator = require("../../../../common/constants/locator");
var _license = require("../../license");
var _check_ml_nodes = require("../../ml_nodes_check/check_ml_nodes");
var _check_capabilities = require("../../capabilities/check_capabilities");
var _page_header = require("../../components/page_header");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileDataVisualizerPage = () => {
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  const {
    services: {
      docLinks,
      dataVisualizer,
      data: {
        dataViews: {
          get: getDataView
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const mlLocator = (0, _kibana.useMlLocator)();
  (0, _check_ml_nodes.getMlNodeCount)();
  const [FileDataVisualizer, setFileDataVisualizer] = (0, _react.useState)(null);
  const [resultLinks, setResultLinks] = (0, _react.useState)(null);
  const getAdditionalLinks = (0, _react.useMemo)(() => [async ({
    dataViewId,
    globalState
  }) => [{
    id: 'create_ml_job',
    title: _i18n.i18n.translate('xpack.ml.fileDatavisualizer.actionsPanel.anomalyDetectionTitle', {
      defaultMessage: 'Create ML job'
    }),
    description: '',
    icon: 'machineLearningApp',
    type: 'file',
    getUrl: async () => {
      return await mlLocator.getUrl({
        page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_TYPE,
        pageState: {
          index: dataViewId,
          globalState
        }
      });
    },
    canDisplay: async () => {
      try {
        const {
          timeFieldName
        } = await getDataView(dataViewId);
        return (0, _license.isFullLicense)() && timeFieldName !== undefined && (0, _check_capabilities.checkPermission)('canCreateJob') && (0, _check_ml_nodes.mlNodesAvailable)();
      } catch (error) {
        return false;
      }
    }
  }, {
    id: 'open_in_data_viz',
    title: _i18n.i18n.translate('xpack.ml.fileDatavisualizer.actionsPanel.dataframeTitle', {
      defaultMessage: 'Open in Data Visualizer'
    }),
    description: '',
    icon: 'dataVisualizer',
    type: 'file',
    getUrl: async () => {
      return await mlLocator.getUrl({
        page: _locator.ML_PAGES.DATA_VISUALIZER_INDEX_VIEWER,
        pageState: {
          index: dataViewId,
          globalState
        }
      });
    },
    canDisplay: async () => dataViewId !== ''
  }]],
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [mlLocator]);
  (0, _react.useEffect)(() => {
    // ML uses this function
    if (dataVisualizer !== undefined) {
      (0, _check_ml_nodes.getMlNodeCount)();
      const {
        getFileDataVisualizerComponent
      } = dataVisualizer;
      getFileDataVisualizerComponent().then(resp => {
        const items = resp();
        setFileDataVisualizer(() => items.component);
        setResultLinks(items.resultLinks);
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, FileDataVisualizer !== null ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataVisualizer.pageHeader",
    defaultMessage: "Data Visualizer"
  })), /*#__PURE__*/_react.default.createElement(FileDataVisualizer, {
    getAdditionalLinks: getAdditionalLinks,
    resultLinks: resultLinks !== null && resultLinks !== void 0 ? resultLinks : undefined
  })) : null, /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: docLinks.links.ml.guide
  }));
};
exports.FileDataVisualizerPage = FileDataVisualizerPage;