"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorationResultsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _dependency_cache = require("../../../../../util/dependency_cache");
var _kibana = require("../../../../../contexts/kibana");
var _expandable_section = require("../expandable_section");
var _use_exploration_results = require("./use_exploration_results");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExplorationResultsTable = exports.ExplorationResultsTable = /*#__PURE__*/_react.default.memo(({
  dataView,
  jobConfig,
  needsDestDataView,
  searchQuery
}) => {
  const {
    services: {
      mlServices: {
        mlApiServices
      }
    }
  } = (0, _kibana.useMlKibana)();
  const classificationData = (0, _use_exploration_results.useExplorationResults)(dataView, jobConfig, searchQuery, (0, _dependency_cache.getToastNotifications)(), mlApiServices);
  if (jobConfig === undefined || classificationData === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlDFAnalyticsExplorationTablePanel"
  }, /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSectionResults, {
    indexData: classificationData,
    dataView: dataView,
    resultsField: jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.dest.results_field,
    jobConfig: jobConfig,
    needsDestDataView: needsDestDataView,
    searchQuery: searchQuery
  }));
});