"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRocCurve = void 0;
var _react = require("react");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _new_job_capabilities_service_analytics = require("../../../../../services/new_job_capabilities/new_job_capabilities_service_analytics");
var _analytics = require("../../../../common/analytics");
var _common = require("../../../../common");
var _column_data = require("./column_data");
var _is_training_filter = require("./is_training_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AUC_VALUE_LABEL = 'AUC';
const AUC_ROUNDING_VALUE = 100000;
const ROC_CLASS_NAME = 'ROC';
const BINARY_CLASSIFICATION_THRESHOLD = 2;
const useRocCurve = (jobConfig, searchQuery, columns) => {
  const classificationClasses = columns.filter(d => d !== _column_data.ACTUAL_CLASS_ID && d !== _column_data.OTHER_CLASS_ID);

  // For binary classification jobs we only need to get the data for one class.
  if (classificationClasses.length <= BINARY_CLASSIFICATION_THRESHOLD) {
    classificationClasses.splice(1);
  }
  const [rocCurveData, setRocCurveData] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    async function loadRocCurveData() {
      setIsLoading(true);
      const dependentVariable = (0, _mlDataFrameAnalyticsUtils.getDependentVar)(jobConfig.analysis);
      const resultsField = jobConfig.dest.results_field;
      const newRocCurveData = [];
      let requiresKeyword = false;
      const errors = [];
      try {
        requiresKeyword = _new_job_capabilities_service_analytics.newJobCapsServiceAnalytics.isKeywordAndTextType(dependentVariable);
      } catch (e) {
        // Additional error handling due to missing field type is handled by loadEvalData
        console.error('Unable to load new field types', e); // eslint-disable-line no-console
      }
      for (let i = 0; i < classificationClasses.length; i++) {
        const rocCurveClassName = classificationClasses[i];
        const evalData = await (0, _common.loadEvalData)({
          isTraining: (0, _is_training_filter.isTrainingFilter)(searchQuery, resultsField),
          index: jobConfig.dest.index,
          dependentVariable,
          resultsField,
          predictionFieldName: (0, _mlDataFrameAnalyticsUtils.getPredictionFieldName)(jobConfig.analysis),
          searchQuery,
          jobType: _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION,
          requiresKeyword,
          rocCurveClassName,
          includeMulticlassConfusionMatrix: false
        });
        if (evalData.success === true && evalData.eval && (0, _analytics.isClassificationEvaluateResponse)(evalData.eval)) {
          var _evalData$eval, _evalData$eval$classi, _evalData$eval$classi2, _evalData$eval2, _evalData$eval2$class, _evalData$eval2$class2;
          const auc = ((_evalData$eval = evalData.eval) === null || _evalData$eval === void 0 ? void 0 : (_evalData$eval$classi = _evalData$eval.classification) === null || _evalData$eval$classi === void 0 ? void 0 : (_evalData$eval$classi2 = _evalData$eval$classi.auc_roc) === null || _evalData$eval$classi2 === void 0 ? void 0 : _evalData$eval$classi2.value) || 0;

          // For binary classification jobs we use the 'ROC' label,
          // for multi-class classification the original class name.
          const rocCurveClassLabel = classificationClasses.length > BINARY_CLASSIFICATION_THRESHOLD ? classificationClasses[i] : ROC_CLASS_NAME;
          const rocCurveDataForClass = (((_evalData$eval2 = evalData.eval) === null || _evalData$eval2 === void 0 ? void 0 : (_evalData$eval2$class = _evalData$eval2.classification) === null || _evalData$eval2$class === void 0 ? void 0 : (_evalData$eval2$class2 = _evalData$eval2$class.auc_roc) === null || _evalData$eval2$class2 === void 0 ? void 0 : _evalData$eval2$class2.curve) || []).map(d => ({
            class_name: `${rocCurveClassLabel} (${AUC_VALUE_LABEL}: ${Math.round(auc * AUC_ROUNDING_VALUE) / AUC_ROUNDING_VALUE})`,
            ...d
          }));
          newRocCurveData.push(...rocCurveDataForClass);
        } else if (evalData.error !== null) {
          errors.push(evalData.error);
        }
      }
      setError(errors.length > 0 ? errors : null);
      setRocCurveData(newRocCurveData);
      setIsLoading(false);
    }
    loadRocCurveData();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify([jobConfig, searchQuery, columns])]);
  return {
    rocCurveData,
    // To match the data that was generated for the class,
    // for multi-class classification jobs this returns all class names,
    // for binary classification it returns just ['ROC'].
    classificationClasses: classificationClasses.length > BINARY_CLASSIFICATION_THRESHOLD ? classificationClasses : [ROC_CLASS_NAME],
    error,
    isLoading
  };
};
exports.useRocCurve = useRocCurve;