"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IdBadges = IdBadges;
var _react = _interopRequireDefault(require("react"));
var _propTypes = require("prop-types");
var _eui = require("@elastic/eui");
var _job_selector_badge = require("../job_selector_badge");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IdBadges({
  limit,
  maps,
  onLinkClick,
  selectedIds,
  showAllBarBadges
}) {
  const badges = [];
  const currentGroups = [];
  // Create group badges. Skip job ids here.
  for (let i = 0; i < selectedIds.length; i++) {
    const currentId = selectedIds[i];
    if (maps.groupsMap[currentId] !== undefined) {
      currentGroups.push(currentId);
      badges.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: currentId
      }, /*#__PURE__*/_react.default.createElement(_job_selector_badge.JobSelectorBadge, {
        id: currentId,
        isGroup: true,
        numJobs: maps.groupsMap[currentId].length
      })));
    } else {
      continue;
    }
  }
  // Create jobId badges for jobs with no groups or with groups not selected
  for (let i = 0; i < selectedIds.length; i++) {
    const currentId = selectedIds[i];
    if (maps.groupsMap[currentId] === undefined) {
      const jobGroups = maps.jobsMap[currentId] || [];
      if (jobGroups.some(g => currentGroups.includes(g)) === false) {
        badges.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          key: currentId
        }, /*#__PURE__*/_react.default.createElement(_job_selector_badge.JobSelectorBadge, {
          id: currentId
        })));
      } else {
        continue;
      }
    } else {
      continue;
    }
  }
  if (showAllBarBadges || badges.length <= limit) {
    if (badges.length > limit) {
      badges.push( /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        key: "more-badges-bar-link",
        onClick: onLinkClick
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        grow: false,
        size: "xs"
      }, _i18n.i18n.translate('xpack.ml.jobSelector.hideBarBadges', {
        defaultMessage: 'Hide'
      }))));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, badges);
  } else {
    const overFlow = badges.length - limit;
    badges.splice(limit);
    badges.push( /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      key: "more-badges-bar-link",
      onClick: onLinkClick
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      size: "xs"
    }, _i18n.i18n.translate('xpack.ml.jobSelector.showBarBadges', {
      defaultMessage: `And {overFlow} more`,
      values: {
        overFlow
      }
    }))));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, badges);
  }
}
IdBadges.propTypes = {
  limit: _propTypes.PropTypes.number,
  maps: _propTypes.PropTypes.shape({
    jobsMap: _propTypes.PropTypes.object,
    groupsMap: _propTypes.PropTypes.object
  }),
  onLinkClick: _propTypes.PropTypes.func,
  selectedIds: _propTypes.PropTypes.array,
  showAllBarBadges: _propTypes.PropTypes.bool
};