"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFieldStatsTrigger = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui_combo_box_with_field_stats = require("./eui_combo_box_with_field_stats");
var _ = require(".");
var _field_stats_info_button = require("./field_stats_info_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFieldStatsTrigger = () => {
  const {
    setIsFlyoutVisible,
    setFieldName,
    populatedFields
  } = (0, _.useFieldStatsFlyoutContext)();
  const closeFlyout = (0, _react.useCallback)(() => setIsFlyoutVisible(false), [setIsFlyoutVisible]);
  const handleFieldStatsButtonClick = (0, _react.useCallback)(field => {
    if (typeof field.id === 'string') {
      setFieldName(field.id);
      setIsFlyoutVisible(true);
    }
  }, [setFieldName, setIsFlyoutVisible]);
  const renderOption = (0, _react.useCallback)((option, searchValue) => {
    const field = option.field;
    return option.isGroupLabelOption || !field ? option.label : /*#__PURE__*/_react.default.createElement(_field_stats_info_button.FieldStatsInfoButton, {
      isEmpty: populatedFields && !populatedFields.has(field.id),
      field: field,
      label: option.label,
      onButtonClick: handleFieldStatsButtonClick
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [handleFieldStatsButtonClick, populatedFields === null || populatedFields === void 0 ? void 0 : populatedFields.size]);
  return {
    renderOption,
    setIsFlyoutVisible,
    setFieldName,
    handleFieldStatsButtonClick,
    closeFlyout,
    optionCss: _eui_combo_box_with_field_stats.optionCss,
    populatedFields
  };
};
exports.useFieldStatsTrigger = useFieldStatsTrigger;