"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopulatedFieldsCacheManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_EXPIRATION_MS = 60000;
class PopulatedFieldsCacheManager {
  constructor(_expirationDurationMs = DEFAULT_EXPIRATION_MS) {
    (0, _defineProperty2.default)(this, "_resultsCache", new Map());
    (0, _defineProperty2.default)(this, "_lastUpdatedTimestamps", new Map());
    this._expirationDurationMs = _expirationDurationMs;
  }
  clearOldCacheIfNeeded() {
    if (this._resultsCache.size > 10) {
      this._resultsCache.clear();
      this._lastUpdatedTimestamps.clear();
    }
  }
  clearExpiredCache(key) {
    // If result is available but past the expiration duration, clear cache
    const lastUpdatedTs = this._lastUpdatedTimestamps.get(key);
    const now = Date.now();
    if (lastUpdatedTs !== undefined && lastUpdatedTs - now > this._expirationDurationMs) {
      this._resultsCache.delete(key);
    }
  }
  get(key) {
    return this._resultsCache.get(key);
  }
  set(key, value) {
    this.clearExpiredCache(key);
    this.clearOldCacheIfNeeded();
    this._resultsCache.set(key, Date.now());
    this._resultsCache.set(key, value);
  }
}
exports.PopulatedFieldsCacheManager = PopulatedFieldsCacheManager;