"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatsFlyoutProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mlDataGrid = require("@kbn/ml-data-grid");
var _mlStringHash = require("@kbn/ml-string-hash");
var _rxjs = require("rxjs");
var _get_merged_populated_fields_query = require("./populated_fields/get_merged_populated_fields_query");
var _kibana = require("../../contexts/kibana");
var _field_stats_flyout = require("./field_stats_flyout");
var _use_field_stats_flytout_context = require("./use_field_stats_flytout_context");
var _populated_fields_cache_manager = require("./populated_fields/populated_fields_cache_manager");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldStatsFlyoutProvider = ({
  dataView,
  fieldStatsServices,
  timeRangeMs,
  dslQuery,
  disablePopulatedFields = false,
  children
}) => {
  const {
    services: {
      data: {
        search
      }
    }
  } = (0, _kibana.useMlKibana)();
  const [isFieldStatsFlyoutVisible, setFieldStatsIsFlyoutVisible] = (0, _react.useState)(false);
  const [fieldName, setFieldName] = (0, _react.useState)();
  const [fieldValue, setFieldValue] = (0, _react.useState)();
  const toggleFieldStatsFlyoutVisible = (0, _react.useCallback)(() => setFieldStatsIsFlyoutVisible(!isFieldStatsFlyoutVisible), [isFieldStatsFlyoutVisible]);
  const [manager] = (0, _react.useState)(new _populated_fields_cache_manager.PopulatedFieldsCacheManager());
  const [populatedFields, setPopulatedFields] = (0, _react.useState)();
  const abortController = (0, _react.useRef)(new AbortController());
  (0, _react.useEffect)(function fetchSampleDocsEffect() {
    var _dataView$getTimeFiel;
    if (disablePopulatedFields) return;
    let unmounted = false;
    if (abortController.current) {
      abortController.current.abort();
      abortController.current = new AbortController();
    }
    const queryAndRunTimeMappings = (0, _get_merged_populated_fields_query.getMergedSampleDocsForPopulatedFieldsQuery)({
      searchQuery: dslQuery,
      runtimeFields: dataView.getRuntimeMappings(),
      datetimeField: (_dataView$getTimeFiel = dataView.getTimeField()) === null || _dataView$getTimeFiel === void 0 ? void 0 : _dataView$getTimeFiel.name,
      timeRange: timeRangeMs
    });
    const indexPattern = dataView.getIndexPattern();
    const esSearchRequestParams = {
      index: indexPattern,
      body: {
        fields: ['*'],
        _source: false,
        ...queryAndRunTimeMappings,
        size: 500
      }
    };
    const cacheKey = (0, _mlStringHash.stringHash)(JSON.stringify(esSearchRequestParams)).toString();
    const fetchSampleDocuments = async function () {
      try {
        const resp = await (0, _rxjs.lastValueFrom)(search.search({
          params: esSearchRequestParams
        }, {
          abortSignal: abortController.current.signal
        }));
        const docs = resp.rawResponse.hits.hits.map(d => {
          var _d$fields;
          return (0, _mlDataGrid.getProcessedFields)((_d$fields = d.fields) !== null && _d$fields !== void 0 ? _d$fields : {});
        });

        // Get all field names for each returned doc and flatten it
        // to a list of unique field names used across all docs.
        const fieldsWithData = new Set(docs.map(Object.keys).flat(1));
        manager.set(cacheKey, fieldsWithData);
        if (!unmounted) {
          setPopulatedFields(fieldsWithData);
        }
      } catch (e) {
        if (e.name !== 'AbortError') {
          // eslint-disable-next-line no-console
          console.error(`An error occurred fetching sample documents to determine populated field stats.
          \nQuery:\n${JSON.stringify(esSearchRequestParams)}
          \nError:${e}`);
        }
      }
    };
    const cachedResult = manager.get(cacheKey);
    if (cachedResult) {
      return cachedResult;
    } else {
      fetchSampleDocuments();
    }
    return () => {
      unmounted = true;
      abortController.current.abort();
    };
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [JSON.stringify({
    dslQuery,
    dataViewId: dataView.id,
    timeRangeMs
  })]);
  return /*#__PURE__*/_react.default.createElement(_use_field_stats_flytout_context.MLFieldStatsFlyoutContext.Provider, {
    value: {
      isFlyoutVisible: isFieldStatsFlyoutVisible,
      setIsFlyoutVisible: setFieldStatsIsFlyoutVisible,
      toggleFlyoutVisible: toggleFieldStatsFlyoutVisible,
      setFieldName,
      fieldName,
      setFieldValue,
      fieldValue,
      timeRangeMs,
      populatedFields
    }
  }, /*#__PURE__*/_react.default.createElement(_field_stats_flyout.FieldStatsFlyout, {
    dataView: dataView,
    fieldStatsServices: fieldStatsServices,
    timeRangeMs: timeRangeMs,
    dslQuery: dslQuery
  }), children);
};
exports.FieldStatsFlyoutProvider = FieldStatsFlyoutProvider;