"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomUrlList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _mlUrlState = require("@kbn/ml-url-state");
var _kibana = require("../../../contexts/kibana");
var _toast_notification_service = require("../../../services/toast_notification_service");
var _custom_url_utils = require("../../../util/custom_url_utils");
var _utils = require("./utils");
var _parse_interval = require("../../../../../common/util/parse_interval");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isValidTimeRange(timeRange) {
  // Allow empty timeRange string, which gives the 'auto' behaviour.
  if (timeRange === undefined || timeRange.length === 0 || timeRange === _constants.TIME_RANGE_TYPE.AUTO) {
    return true;
  }
  const interval = (0, _parse_interval.parseInterval)(timeRange);
  return interval !== null;
}
/*
 * React component for listing the custom URLs added to a job,
 * with buttons for testing and deleting each custom URL.
 */
const CustomUrlList = ({
  job,
  customUrls,
  onChange: setCustomUrls,
  dataViewListItems,
  isPartialDFAJob
}) => {
  const {
    services: {
      http,
      data: {
        dataViews
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const [expandedUrlIndex, setExpandedUrlIndex] = (0, _react.useState)(null);
  const onLabelChange = (e, index) => {
    if (index < customUrls.length) {
      customUrls[index] = {
        ...customUrls[index],
        url_name: e.target.value
      };
      setCustomUrls([...customUrls]);
    }
  };
  const onUrlValueChange = (e, index) => {
    if (index < customUrls.length) {
      customUrls[index] = {
        ...customUrls[index],
        url_value: e.target.value
      };
      setCustomUrls([...customUrls]);
    }
  };
  const onTimeRangeChange = (e, index) => {
    if (index < customUrls.length) {
      customUrls[index] = {
        ...customUrls[index]
      };
      const timeRange = e.target.value;
      if (timeRange !== undefined && timeRange.length > 0) {
        customUrls[index].time_range = timeRange;
      } else {
        delete customUrls[index].time_range;
      }
      setCustomUrls([...customUrls]);
    }
  };
  const onDeleteButtonClick = index => {
    if (index < customUrls.length) {
      customUrls.splice(index, 1);
      setCustomUrls([...customUrls]);
    }
  };
  const onTestButtonClick = async index => {
    const customUrl = customUrls[index];
    let timefieldName = null;
    if (index < customUrls.length && ((0, _mlDataFrameAnalyticsUtils.isDataFrameAnalyticsConfigs)(job) || isPartialDFAJob) && customUrl.time_range !== undefined && customUrl.time_range !== _constants.TIME_RANGE_TYPE.AUTO) {
      // Ensure cast as dfaJob if it's just a partial from the wizard
      const dfaJob = job;
      let dataViewId;
      // DFA job url - need the timefield to test the URL. Get it from the job config. Use source index when partial job since dest index does not exist yet.
      if (customUrl.url_value.includes('dashboards')) {
        var _dataViewListItems$fi;
        const sourceIndex = Array.isArray(dfaJob.source.index) ? dfaJob.source.index.join() : dfaJob.source.index;
        // need to get the dataview from the dashboard to get timefield
        const indexName = isPartialDFAJob ? sourceIndex : dfaJob.dest.index;
        const backupIndexName = sourceIndex;
        dataViewId = dataViewListItems === null || dataViewListItems === void 0 ? void 0 : (_dataViewListItems$fi = dataViewListItems.find(item => item.title === indexName)) === null || _dataViewListItems$fi === void 0 ? void 0 : _dataViewListItems$fi.id;
        if (!dataViewId) {
          var _dataViewListItems$fi2;
          dataViewId = dataViewListItems === null || dataViewListItems === void 0 ? void 0 : (_dataViewListItems$fi2 = dataViewListItems.find(item => item.title === backupIndexName)) === null || _dataViewListItems$fi2 === void 0 ? void 0 : _dataViewListItems$fi2.id;
        }
      } else {
        var _urlState$_a;
        const urlState = (0, _mlUrlState.parseUrlState)(customUrl.url_value);
        dataViewId = (_urlState$_a = urlState._a) === null || _urlState$_a === void 0 ? void 0 : _urlState$_a.index;
      }
      if (dataViewId) {
        var _dataView$timeFieldNa;
        const dataView = await dataViews.get(dataViewId);
        timefieldName = (_dataView$timeFieldNa = dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName) !== null && _dataView$timeFieldNa !== void 0 ? _dataView$timeFieldNa : null;
      }
    }
    if (index < customUrls.length) {
      try {
        const testUrl = await (0, _utils.getTestUrl)(job, customUrl, timefieldName, undefined, isPartialDFAJob);
        (0, _custom_url_utils.openCustomUrlWindow)(testUrl, customUrl, http.basePath.get());
      } catch (error) {
        displayErrorToast(error, _i18n.i18n.translate('xpack.ml.customUrlEditorList.obtainingUrlToTestConfigurationErrorMessage', {
          defaultMessage: 'An error occurred obtaining the URL to test the configuration'
        }));
      }
    }
  };
  const customUrlRows = customUrls.map((customUrl, index) => {
    // Validate the label.
    const label = customUrl.url_name;
    const otherUrls = [...customUrls];
    otherUrls.splice(index, 1); // Don't compare label with itself.
    const isInvalidLabel = !(0, _custom_url_utils.isValidLabel)(label, otherUrls);
    const invalidLabelError = isInvalidLabel ? [_i18n.i18n.translate('xpack.ml.customUrlEditorList.labelIsNotUniqueErrorMessage', {
      defaultMessage: 'A unique label must be supplied'
    })] : [];

    // Validate the time range.
    const timeRange = customUrl.time_range;
    const isCustomTimeRange = customUrl.is_custom_time_range === true;
    const isInvalidTimeRange = !isValidTimeRange(timeRange);
    const invalidIntervalError = isInvalidTimeRange ? [_i18n.i18n.translate('xpack.ml.customUrlEditorList.invalidTimeRangeFormatErrorMessage', {
      defaultMessage: 'Invalid format'
    })] : [];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      key: `url_${index}`,
      "data-test-subj": `mlJobEditCustomUrlItem_${index}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.customUrlEditorList.labelLabel",
        defaultMessage: "Label"
      }),
      isInvalid: isInvalidLabel,
      error: invalidLabelError,
      "data-test-subj": "mlJobEditCustomUrlItemLabel"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: label,
      isInvalid: isInvalidLabel,
      onChange: e => onLabelChange(e, index),
      "data-test-subj": `mlJobEditCustomUrlLabelInput_${index}`
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.customUrlEditorList.urlLabel",
        defaultMessage: "URL"
      })
    }, index === expandedUrlIndex ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      inputRef: input => {
        if (input) {
          input.focus();
        }
      },
      fullWidth: true,
      value: customUrl.url_value,
      onChange: e => onUrlValueChange(e, index),
      onBlur: () => {
        setExpandedUrlIndex(null);
      },
      "data-test-subj": `mlJobEditCustomUrlTextarea_${index}`
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: customUrl.url_value,
      readOnly: true,
      onFocus: () => setExpandedUrlIndex(index),
      "data-test-subj": `mlJobEditCustomUrlInput_${index}`
    }))), isCustomTimeRange === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.customUrlEditorList.timeRangeLabel",
        defaultMessage: "Time range"
      }),
      error: invalidIntervalError,
      isInvalid: isInvalidTimeRange
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: customUrl.time_range || '',
      isInvalid: isInvalidTimeRange,
      placeholder: _constants.TIME_RANGE_TYPE.AUTO,
      onChange: e => onTimeRangeChange(e, index)
    }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      hasEmptyLabelSpace: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.customUrlEditorList.testCustomUrlTooltip",
        defaultMessage: "Test custom URL"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      color: "primary",
      onClick: () => onTestButtonClick(index),
      iconType: "popout",
      "aria-label": _i18n.i18n.translate('xpack.ml.customUrlEditorList.testCustomUrlAriaLabel', {
        defaultMessage: 'Test custom URL'
      }),
      "data-test-subj": "mlJobEditTestCustomUrlButton"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      hasEmptyLabelSpace: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.customUrlEditorList.deleteCustomUrlTooltip",
        defaultMessage: "Delete custom URL"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      color: "danger",
      onClick: () => onDeleteButtonClick(index),
      iconType: "trash",
      "aria-label": _i18n.i18n.translate('xpack.ml.customUrlEditorList.deleteCustomUrlAriaLabel', {
        defaultMessage: 'Delete custom URL'
      }),
      "data-test-subj": `mlJobEditDeleteCustomUrlButton_${index}`
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlJobEditCustomUrlsList"
  }, customUrlRows);
};
exports.CustomUrlList = CustomUrlList;