"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateADLinks = void 0;
var _react = require("react");
var _kibana = require("../../contexts/kibana");
var _settings = require("../../../../common/constants/settings");
var _job_service = require("../../services/job_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateADLinks = () => {
  const {
    services: {
      http: {
        basePath
      }
    }
  } = (0, _kibana.useMlKibana)();
  const useUserTimeSettings = (0, _kibana.useUiSettings)().get(_settings.ANOMALY_DETECTION_ENABLE_TIME_RANGE);
  const userTimeSettings = (0, _kibana.useUiSettings)().get(_settings.ANOMALY_DETECTION_DEFAULT_TIME_RANGE);
  const createLinkWithUserDefaults = (0, _react.useCallback)((location, jobList) => {
    const resultsUrl = _job_service.mlJobService.createResultsUrlForJobs(jobList, location, useUserTimeSettings === true && userTimeSettings !== undefined ? userTimeSettings : undefined);
    return `${basePath.get()}/app/ml/${resultsUrl}`;
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [basePath]);
  return {
    createLinkWithUserDefaults
  };
};
exports.useCreateADLinks = useCreateADLinks;