"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfluencersCell = void 0;
var _lodash = require("lodash");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _component_utils = require("../../util/component_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Component for rendering a list of record influencers inside a cell in the anomalies table.
 * Truncates long lists of influencers to the supplied limit, with the full list of influencers
 * expanded or collapsed via 'and x more' / 'show less' links.
 */
class InfluencersCell extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {
      showAll: false
    };
  }
  toggleAllInfluencers() {
    this.setState({
      showAll: !this.state.showAll
    });
  }
  renderInfluencers(influencers) {
    const numberToDisplay = this.state.showAll === false ? this.props.limit : influencers.length;
    const displayInfluencers = influencers.slice(0, numberToDisplay);
    const {
      influencerFilter
    } = this.props;
    let othersCount = Math.max(influencers.length - numberToDisplay, 0);
    if (othersCount === 1) {
      // Display the additional influencer.
      displayInfluencers.push(influencers[this.props.limit]);
      othersCount = 0;
    }
    const displayRows = displayInfluencers.map((influencer, index) => /*#__PURE__*/_react.default.createElement("div", {
      key: index
    }, influencer.influencerFieldName, ": ", influencer.influencerFieldValue, influencerFilter !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.influencersCell.addFilterTooltip",
        defaultMessage: "Add filter"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      className: "filter-button",
      onClick: (0, _component_utils.blurButtonOnClick)(() => {
        influencerFilter(influencer.influencerFieldName, influencer.influencerFieldValue, '+');
      }),
      iconType: "plusInCircle",
      "aria-label": _i18n.i18n.translate('xpack.ml.anomaliesTable.influencersCell.addFilterAriaLabel', {
        defaultMessage: 'Add filter'
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.influencersCell.removeFilterTooltip",
        defaultMessage: "Remove filter"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      className: "filter-button",
      onClick: (0, _component_utils.blurButtonOnClick)(() => {
        influencerFilter(influencer.influencerFieldName, influencer.influencerFieldValue, '-');
      }),
      iconType: "minusInCircle",
      "aria-label": _i18n.i18n.translate('xpack.ml.anomaliesTable.influencersCell.removeFilterAriaLabel', {
        defaultMessage: 'Remove filter'
      })
    })))));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, displayRows, this.renderOthers(influencers.length, othersCount));
  }
  renderOthers(totalCount, othersCount) {
    if (othersCount > 0) {
      return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => this.toggleAllInfluencers()
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.influencersCell.moreInfluencersLinkText",
        defaultMessage: "and {othersCount} more",
        values: {
          othersCount
        }
      })));
    } else if (totalCount > this.props.limit + 1) {
      return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => this.toggleAllInfluencers()
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.influencersCell.showLessInfluencersLinkText",
        defaultMessage: "show less"
      })));
    }
  }
  render() {
    const recordInfluencers = this.props.influencers || [];
    const influencers = [];
    recordInfluencers.forEach(influencer => {
      (0, _lodash.each)(influencer, (influencerFieldValue, influencerFieldName) => {
        influencers.push({
          influencerFieldName,
          influencerFieldValue
        });
      });
    });
    return /*#__PURE__*/_react.default.createElement("div", null, this.renderInfluencers(influencers), this.renderOthers(influencers));
  }
}
exports.InfluencersCell = InfluencersCell;
InfluencersCell.propTypes = {
  influencerFilter: _propTypes.default.func,
  influencers: _propTypes.default.array,
  limit: _propTypes.default.number
};