"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireWildcard(require("react"));
require("./_index.scss");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _lodash = require("lodash");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _useLifecycles = _interopRequireDefault(require("react-use/lib/useLifecycles"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _storage = require("../../common/types/storage");
var _dependency_cache = require("./util/dependency_cache");
var _license = require("./license");
var _routing = require("./routing");
var _ml = require("./contexts/ml");
var _get_services = require("./util/get_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const localStorage = new _public.Storage(window.localStorage);
const App = ({
  coreStart,
  deps,
  appMountParams,
  isServerless,
  mlFeatures,
  experimentalFeatures
}) => {
  var _deps$usageCollection, _deps$usageCollection2;
  const pageDeps = {
    history: appMountParams.history,
    setHeaderActionMenu: appMountParams.setHeaderActionMenu,
    setBreadcrumbs: coreStart.chrome.setBreadcrumbs
  };
  const chromeStyle = (0, _useObservable.default)(coreStart.chrome.getChromeStyle$(), 'classic');
  const services = (0, _react.useMemo)(() => {
    return {
      ...coreStart,
      cases: deps.cases,
      charts: deps.charts,
      contentManagement: deps.contentManagement,
      dashboard: deps.dashboard,
      data: deps.data,
      dataViewEditor: deps.dataViewEditor,
      dataViews: deps.data.dataViews,
      dataVisualizer: deps.dataVisualizer,
      embeddable: deps.embeddable,
      fieldFormats: deps.fieldFormats,
      kibanaVersion: deps.kibanaVersion,
      lens: deps.lens,
      licenseManagement: deps.licenseManagement,
      maps: deps.maps,
      observabilityAIAssistant: deps.observabilityAIAssistant,
      presentationUtil: deps.presentationUtil,
      savedObjectsManagement: deps.savedObjectsManagement,
      savedSearch: deps.savedSearch,
      security: deps.security,
      share: deps.share,
      storage: localStorage,
      triggersActionsUi: deps.triggersActionsUi,
      uiActions: deps.uiActions,
      unifiedSearch: deps.unifiedSearch,
      usageCollection: deps.usageCollection,
      mlServices: (0, _get_services.getMlGlobalServices)(coreStart.http, deps.data.dataViews, deps.usageCollection)
    };
  }, [deps, coreStart]);
  (0, _useLifecycles.default)(function setupLicenseOnMount() {
    (0, _license.setLicenseCache)(services.mlServices.mlLicense);
    services.mlServices.mlLicense.setup(deps.licensing.license$);
  }, function destroyLicenseOnUnmount() {
    services.mlServices.mlLicense.unsubscribe();
  });

  // Wait for license and capabilities to be retrieved before rendering the app.
  const licenseReady = (0, _useObservable.default)(services.mlServices.mlLicense.isLicenseReady$, false);
  const mlCapabilities = (0, _useObservable.default)(services.mlServices.mlCapabilities.capabilities$, services.mlServices.mlCapabilities.getCapabilities());
  if (!licenseReady || !mlCapabilities) return null;
  const startServices = (0, _lodash.pick)(coreStart, 'analytics', 'i18n', 'theme');
  const datePickerDeps = {
    ...(0, _lodash.pick)(services, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'i18n']),
    uiSettingsKeys: _common.UI_SETTINGS,
    showFrozenDataTierChoice: !isServerless
  };
  const ApplicationUsageTrackingProvider = (_deps$usageCollection = (_deps$usageCollection2 = deps.usageCollection) === null || _deps$usageCollection2 === void 0 ? void 0 : _deps$usageCollection2.components.ApplicationUsageTrackingProvider) !== null && _deps$usageCollection !== void 0 ? _deps$usageCollection : _react.default.Fragment;
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, startServices, /*#__PURE__*/_react.default.createElement(ApplicationUsageTrackingProvider, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.ML_STORAGE_KEYS
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_ml.EnabledFeaturesContextProvider, {
    isServerless: isServerless,
    mlFeatures: mlFeatures,
    showMLNavMenu: chromeStyle === 'classic',
    experimentalFeatures: experimentalFeatures
  }, /*#__PURE__*/_react.default.createElement(_routing.MlRouter, {
    pageDeps: pageDeps
  })))))));
};
const renderApp = (coreStart, deps, appMountParams, isServerless, mlFeatures, experimentalFeatures) => {
  (0, _dependency_cache.setDependencyCache)({
    timefilter: deps.data.query.timefilter,
    fieldFormats: deps.fieldFormats,
    config: coreStart.uiSettings,
    docLinks: coreStart.docLinks,
    toastNotifications: coreStart.notifications.toasts,
    recentlyAccessed: coreStart.chrome.recentlyAccessed,
    application: coreStart.application,
    http: coreStart.http,
    maps: deps.maps
  });
  appMountParams.onAppLeave(actions => actions.default());
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(App, {
    coreStart: coreStart,
    deps: deps,
    appMountParams: appMountParams,
    isServerless: isServerless,
    mlFeatures: mlFeatures,
    experimentalFeatures: experimentalFeatures
  }), appMountParams.element);
  return () => {
    (0, _dependency_cache.clearCache)();
    _reactDom.default.unmountComponentAtNode(appMountParams.element);
    deps.data.search.session.clear();
  };
};
exports.renderApp = renderApp;