"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibanaContextForPluginProvider = exports.useKibanaContextForPlugin = exports.createKibanaContextForPlugin = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createKibanaContextForPlugin = core => (0, _public.createKibanaReactContext)({
  ...core
});
exports.createKibanaContextForPlugin = createKibanaContextForPlugin;
const useKibanaContextForPlugin = exports.useKibanaContextForPlugin = _public.useKibana;
const useKibanaContextForPluginProvider = core => {
  const {
    Provider
  } = (0, _react.useMemo)(() => createKibanaContextForPlugin(core), [core]);
  return Provider;
};
exports.useKibanaContextForPluginProvider = useKibanaContextForPluginProvider;