"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeCrossPanelActions = initializeCrossPanelActions;
var _lodash = _interopRequireDefault(require("lodash"));
var _public = require("@kbn/unified-search-plugin/public");
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _elasticsearch_util = require("../../common/elasticsearch_util");
var _map_embeddables_singleton = require("./map_embeddables_singleton");
var _map_selectors = require("../selectors/map_selectors");
var _actions = require("../actions");
var _kibana_services = require("../kibana_services");
var _get_geo_fields_label = require("./get_geo_fields_label");
var _non_serializable_instances = require("../reducers/non_serializable_instances");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initializeCrossPanelActions({
  controlledBy,
  getActionContext,
  getApi,
  savedMap,
  state,
  uuid
}) {
  const isMovementSynchronized$ = new _rxjs.BehaviorSubject(state.isMovementSynchronized);
  function getIsMovementSynchronized() {
    var _isMovementSynchroniz;
    return (_isMovementSynchroniz = isMovementSynchronized$.value) !== null && _isMovementSynchroniz !== void 0 ? _isMovementSynchroniz : true;
  }
  function setIsMovementSynchronized(next) {
    isMovementSynchronized$.next(next);
  }
  const isFilterByMapExtent$ = new _rxjs.BehaviorSubject(state.filterByMapExtent);
  function getIsFilterByMapExtent() {
    var _isFilterByMapExtent$;
    return (_isFilterByMapExtent$ = isFilterByMapExtent$.value) !== null && _isFilterByMapExtent$ !== void 0 ? _isFilterByMapExtent$ : false;
  }
  function setIsFilterByMapExtent(next) {
    isFilterByMapExtent$.next(next);
  }
  let prevMapExtent;
  function mapSyncHandler(lat, lon, zoom) {
    // auto fit to bounds is not compatable with map synchronization
    // auto fit to bounds may cause map location to never stablize and bound back and forth between bounds on different maps
    if ((0, _map_selectors.getMapSettings)(savedMap.getStore().getState()).autoFitToDataBounds) {
      savedMap.getStore().dispatch((0, _actions.setMapSettings)({
        autoFitToDataBounds: false
      }));
    }
    savedMap.getStore().dispatch((0, _actions.setGotoWithCenter)({
      lat,
      lon,
      zoom
    }));
  }
  function gotoSynchronizedLocation() {
    const syncedLocation = _map_embeddables_singleton.mapEmbeddablesSingleton.getLocation();
    if (syncedLocation) {
      // set map to synchronized view
      mapSyncHandler(syncedLocation.lat, syncedLocation.lon, syncedLocation.zoom);
      return;
    }
    if (!(0, _map_selectors.getMapReady)(savedMap.getStore().getState())) {
      // Initialize synchronized view to map's goto
      // Use goto because un-rendered map will not have accurate mapCenter and mapZoom.
      const goto = (0, _map_selectors.getGoto)(savedMap.getStore().getState());
      if (goto && goto.center) {
        _map_embeddables_singleton.mapEmbeddablesSingleton.setLocation(uuid, goto.center.lat, goto.center.lon, goto.center.zoom);
        return;
      }
    }

    // Initialize synchronized view to map's view
    const center = (0, _map_selectors.getMapCenter)(savedMap.getStore().getState());
    const zoom = (0, _map_selectors.getMapZoom)(savedMap.getStore().getState());
    _map_embeddables_singleton.mapEmbeddablesSingleton.setLocation(uuid, center.lat, center.lon, zoom);
  }

  // debounce to fix timing issue for dashboard with multiple maps with synchronized movement and filter by map extent enabled
  const setMapExtentFilter = _lodash.default.debounce(() => {
    const mapExtent = (0, _map_selectors.getMapExtent)(savedMap.getStore().getState());
    const geoFieldNames = _map_embeddables_singleton.mapEmbeddablesSingleton.getGeoFieldNames();
    if (mapExtent === undefined || geoFieldNames.length === 0) {
      return;
    }
    prevMapExtent = mapExtent;
    const mapExtentFilter = (0, _elasticsearch_util.createExtentFilter)(mapExtent, geoFieldNames);
    mapExtentFilter.meta.controlledBy = controlledBy;
    mapExtentFilter.meta.alias = _i18n.i18n.translate('xpack.maps.embeddable.boundsFilterLabel', {
      defaultMessage: '{geoFieldsLabel} within map bounds',
      values: {
        geoFieldsLabel: (0, _get_geo_fields_label.getGeoFieldsLabel)(geoFieldNames)
      }
    });
    const executeContext = {
      ...getActionContext(),
      filters: [mapExtentFilter],
      controlledBy
    };
    const action = (0, _kibana_services.getUiActions)().getAction(_public.ACTION_GLOBAL_APPLY_FILTER);
    if (!action) {
      throw new Error('Unable to apply map extent filter, could not locate action');
    }
    action.execute(executeContext);
  }, 100);
  function clearMapExtentFilter() {
    prevMapExtent = undefined;
    const executeContext = {
      ...getActionContext(),
      filters: [],
      controlledBy
    };
    const action = (0, _kibana_services.getUiActions)().getAction(_public.ACTION_GLOBAL_APPLY_FILTER);
    if (!action) {
      throw new Error('Unable to apply map extent filter, could not locate action');
    }
    action.execute(executeContext);
  }
  _map_embeddables_singleton.mapEmbeddablesSingleton.register(uuid, {
    getTitle: () => {
      const mapApi = getApi();
      const title = mapApi ? (0, _presentationPublishing.getPanelTitle)(mapApi) : undefined;
      return title ? title : _i18n.i18n.translate('xpack.maps.embeddable.untitleMap', {
        defaultMessage: 'Untitled map'
      });
    },
    onLocationChange: mapSyncHandler,
    getIsMovementSynchronized,
    setIsMovementSynchronized: isMovementSynchronized => {
      setIsMovementSynchronized(isMovementSynchronized);
      if (isMovementSynchronized) {
        gotoSynchronizedLocation();
      } else if (!isMovementSynchronized && savedMap.getAutoFitToBounds()) {
        // restore autoFitToBounds when isMovementSynchronized disabled
        savedMap.getStore().dispatch((0, _actions.setMapSettings)({
          autoFitToDataBounds: true
        }));
      }
    },
    getIsFilterByMapExtent,
    setIsFilterByMapExtent: isFilterByMapExtent => {
      setIsFilterByMapExtent(isFilterByMapExtent);
      if (isFilterByMapExtent) {
        setMapExtentFilter();
      } else {
        clearMapExtentFilter();
      }
    },
    getGeoFieldNames: () => {
      return (0, _map_selectors.getGeoFieldNames)(savedMap.getStore().getState());
    }
  });
  if (getIsMovementSynchronized()) {
    gotoSynchronizedLocation();
  }

  // Passing callback into redux store instead of regular pattern of getting redux state changes for performance reasons
  savedMap.getStore().dispatch((0, _non_serializable_instances.setOnMapMove)((lat, lon, zoom) => {
    if (getIsMovementSynchronized()) {
      _map_embeddables_singleton.mapEmbeddablesSingleton.setLocation(uuid, lat, lon, zoom);
    }
  }));
  const unsubscribeFromStore = savedMap.getStore().subscribe(() => {
    if (!(0, _map_selectors.getMapReady)(savedMap.getStore().getState())) {
      return;
    }
    if (getIsFilterByMapExtent() && !_lodash.default.isEqual(prevMapExtent, (0, _map_selectors.getMapExtent)(savedMap.getStore().getState()))) {
      setMapExtentFilter();
    }
  });
  return {
    cleanup: () => {
      _map_embeddables_singleton.mapEmbeddablesSingleton.unregister(uuid);
      unsubscribeFromStore();
    },
    comparators: {
      isMovementSynchronized: [isMovementSynchronized$, setIsMovementSynchronized],
      filterByMapExtent: [isFilterByMapExtent$, setIsFilterByMapExtent]
    },
    getIsFilterByMapExtent,
    serialize: () => {
      return {
        isMovementSynchronized: isMovementSynchronized$.value,
        filterByMapExtent: isFilterByMapExtent$.value
      };
    }
  };
}