"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureEditTools = FeatureEditTools;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/usage-collection-plugin/public");
var _constants = require("../../../../../common/constants");
var _vector_circle_icon = require("./vector_circle_icon");
var _vector_line_icon = require("./vector_line_icon");
var _vector_square_icon = require("./vector_square_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FeatureEditTools(props) {
  const drawLineSelected = props.drawShape === _constants.DRAW_SHAPE.LINE;
  const drawPolygonSelected = props.drawShape === _constants.DRAW_SHAPE.POLYGON;
  const drawCircleSelected = props.drawShape === _constants.DRAW_SHAPE.DISTANCE;
  const drawBBoxSelected = props.drawShape === _constants.DRAW_SHAPE.BOUNDS;
  const drawPointSelected = props.drawShape === _constants.DRAW_SHAPE.POINT;
  const deleteSelected = props.drawShape === _constants.DRAW_SHAPE.DELETE;
  const isWaiting = props.drawShape === _constants.DRAW_SHAPE.WAIT;
  function toggleDrawShape(mode) {
    if (mode && props.drawShape === mode) {
      props.setDrawShape(null);
    } else {
      props.setDrawShape(mode);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
    viewId: "featureEditTools"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    className: "mapToolbarOverlay__buttonGroup mapToolbarOverlay__buttonGroupAnimated"
  }, props.pointsOnly ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: (0, _classnames.default)({
      'mapToolbarOverlay__buttonIcon-empty': !drawLineSelected
    }),
    key: "line",
    size: "s",
    onClick: () => toggleDrawShape(_constants.DRAW_SHAPE.LINE),
    iconType: _vector_line_icon.VectorLineIcon,
    "aria-label": _i18n.i18n.translate('xpack.maps.toolbarOverlay.featureDraw.drawLineLabel', {
      defaultMessage: 'Draw line'
    }),
    title: _i18n.i18n.translate('xpack.maps.toolbarOverlay.featureDraw.drawLineTitle', {
      defaultMessage: 'Draw line'
    }),
    "aria-pressed": drawLineSelected,
    isSelected: drawLineSelected,
    display: drawLineSelected ? 'fill' : 'empty',
    isDisabled: isWaiting
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: (0, _classnames.default)({
      'mapToolbarOverlay__buttonIcon-empty': !drawPolygonSelected
    }),
    key: "polygon",
    size: "s",
    onClick: () => toggleDrawShape(_constants.DRAW_SHAPE.POLYGON),
    iconType: "node",
    "aria-label": _i18n.i18n.translate('xpack.maps.toolbarOverlay.featureDraw.drawPolygonLabel', {
      defaultMessage: 'Draw polygon'
    }),
    title: _i18n.i18n.translate('xpack.maps.toolbarOverlay.featureDraw.drawPolygonTitle', {
      defaultMessage: 'Draw polygon'
    }),
    "aria-pressed": drawPolygonSelected,
    isSelected: drawPolygonSelected,
    display: drawPolygonSelected ? 'fill' : 'empty',
    isDisabled: isWaiting
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: (0, _classnames.default)({
      'mapToolbarOverlay__buttonIcon-empty': !drawCircleSelected
    }),
    key: "circle",
    size: "s",
    onClick: () => toggleDrawShape(_constants.DRAW_SHAPE.DISTANCE),
    iconType: _vector_circle_icon.VectorCircleIcon,
    "aria-label": _i18n.i18n.translate('xpack.maps.toolbarOverlay.featureDraw.drawCircleLabel', {
      defaultMessage: 'Draw circle'
    }),
    title: _i18n.i18n.translate('xpack.maps.toolbarOverlay.featureDraw.drawCircleTitle', {
      defaultMessage: 'Draw circle'
    }),
    "aria-pressed": drawCircleSelected,
    isSelected: drawCircleSelected,
    display: drawCircleSelected ? 'fill' : 'empty',
    isDisabled: isWaiting
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: (0, _classnames.default)({
      'mapToolbarOverlay__buttonIcon-empty': !drawBBoxSelected
    }),
    key: "boundingBox",
    size: "s",
    onClick: () => toggleDrawShape(_constants.DRAW_SHAPE.BOUNDS),
    iconType: _vector_square_icon.VectorSquareIcon,
    "aria-label": _i18n.i18n.translate('xpack.maps.toolbarOverlay.featureDraw.drawBBoxLabel', {
      defaultMessage: 'Draw bounding box'
    }),
    title: _i18n.i18n.translate('xpack.maps.toolbarOverlay.featureDraw.drawBBoxTitle', {
      defaultMessage: 'Draw bounding box'
    }),
    "aria-pressed": drawBBoxSelected,
    isSelected: drawBBoxSelected,
    display: drawBBoxSelected ? 'fill' : 'empty',
    isDisabled: isWaiting
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: (0, _classnames.default)({
      'mapToolbarOverlay__buttonIcon-empty': !drawPointSelected
    }),
    key: "point",
    size: "s",
    onClick: () => toggleDrawShape(_constants.DRAW_SHAPE.POINT),
    iconType: "dot",
    "aria-label": _i18n.i18n.translate('xpack.maps.toolbarOverlay.featureDraw.drawPointLabel', {
      defaultMessage: 'Draw point'
    }),
    title: _i18n.i18n.translate('xpack.maps.toolbarOverlay.featureDraw.drawPointTitle', {
      defaultMessage: 'Draw point'
    }),
    "aria-pressed": drawPointSelected,
    isSelected: drawPointSelected,
    display: drawPointSelected ? 'fill' : 'empty',
    isDisabled: isWaiting
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: (0, _classnames.default)({
      'mapToolbarOverlay__buttonIcon-empty': !deleteSelected
    }),
    key: "delete",
    size: "s",
    onClick: () => toggleDrawShape(_constants.DRAW_SHAPE.DELETE),
    iconType: "trash",
    "aria-label": _i18n.i18n.translate('xpack.maps.toolbarOverlay.featureDraw.deletePointOrShapeLabel', {
      defaultMessage: 'Delete point or shape'
    }),
    title: _i18n.i18n.translate('xpack.maps.toolbarOverlay.featureDraw.deletePointOrShapeTitle', {
      defaultMessage: 'Delete point or shape'
    }),
    "aria-pressed": deleteSelected,
    isSelected: deleteSelected,
    display: deleteSelected ? 'fill' : 'empty',
    isDisabled: isWaiting
  })));
}