"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StaticLabelForm = StaticLabelForm;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StaticLabelForm({
  onStaticStyleChange,
  staticDynamicSelect,
  styleProperty
}) {
  const onValueChange = event => {
    onStaticStyleChange(styleProperty.getStyleName(), {
      value: event.target.value
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "mapStyleSettings__fixedBox"
  }, staticDynamicSelect), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.maps.styles.staticLabel.valuePlaceholder', {
      defaultMessage: 'symbol label'
    }),
    value: styleProperty.getOptions().value,
    onChange: onValueChange,
    "aria-label": _i18n.i18n.translate('xpack.maps.styles.staticLabel.valueAriaLabel', {
      defaultMessage: 'symbol label'
    }),
    compressed: true
  })));
}