"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByLabel = GroupByLabel;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n_constants = require("./i18n_constants");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GroupByLabel() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("dl", null, /*#__PURE__*/_react.default.createElement("dt", null, _i18n_constants.TIME_SERIES_LABEL), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.source.esGeoLine.groupBy.timeseriesDescription",
      defaultMessage: "Create a track for each unique time series. Track is simplifed when number of points exceeds limit."
    }))), /*#__PURE__*/_react.default.createElement("dt", null, _i18n_constants.TERMS_LABEL), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.source.esGeoGrid.groupBy.termsDescription",
      defaultMessage: "Create a track for top {maxTermsTracks} terms. Track is truncated when number of points exceeds limit.",
      values: {
        maxTermsTracks: _constants.MAX_TERMS_TRACKS
      }
    })))))
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.source.esGeoGrid.groupByLabel",
    defaultMessage: "Group by"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "questionInCircle",
    color: "subdued"
  })));
}