"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementLandingPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _managementCardsNavigation = require("@kbn/management-cards-navigation");
var _management_context = require("../management_app/management_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ManagementLandingPage = ({
  setBreadcrumbs,
  onAppMounted
}) => {
  const {
    appBasePath,
    sections,
    kibanaVersion,
    cardsNavigationConfig
  } = (0, _management_context.useAppContext)();
  setBreadcrumbs();
  (0, _react.useEffect)(() => {
    onAppMounted('');
  }, [onAppMounted]);
  if (cardsNavigationConfig !== null && cardsNavigationConfig !== void 0 && cardsNavigationConfig.enabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      restrictWidth: true,
      "data-test-subj": "cards-navigation-page"
    }, /*#__PURE__*/_react.default.createElement(_managementCardsNavigation.CardsNavigation, {
      sections: sections,
      appBasePath: appBasePath,
      hideLinksTo: cardsNavigationConfig === null || cardsNavigationConfig === void 0 ? void 0 : cardsNavigationConfig.hideLinksTo,
      extendedCardNavigationDefinitions: cardsNavigationConfig === null || cardsNavigationConfig === void 0 ? void 0 : cardsNavigationConfig.extendCardNavDefinitions
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
    "data-test-subj": "managementHome",
    iconType: "managementApp",
    title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "management.landing.header",
      defaultMessage: "Welcome to Stack Management {version}",
      values: {
        version: kibanaVersion
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "management.landing.subhead",
      defaultMessage: "Manage your indices, data views, saved objects, Kibana settings, and more."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "management.landing.text",
      defaultMessage: "A complete list of apps is in the menu on the left."
    })))
  });
};
exports.ManagementLandingPage = ManagementLandingPage;