"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogstashPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _services = require("./services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */ // @ts-ignore
class LogstashPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "licenseSubscription", void 0);
    (0, _defineProperty2.default)(this, "capabilities$", new _rxjs.Subject());
  }
  setup(core, plugins) {
    const logstashLicense$ = plugins.licensing.license$.pipe((0, _rxjs.map)(license => new _services.LogstashLicenseService(license)));
    const pluginName = _i18n.i18n.translate('xpack.logstash.managementSection.pipelinesTitle', {
      defaultMessage: 'Logstash Pipelines'
    });
    const managementApp = plugins.management.sections.section.ingest.registerApp({
      id: 'pipelines',
      title: pluginName,
      order: 1,
      mount: async params => {
        const [coreStart] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const isMonitoringEnabled = ('monitoring' in plugins);
        const {
          docTitle
        } = coreStart.chrome;
        docTitle.change(pluginName);
        const unmountAppCallback = await renderApp(coreStart, params, isMonitoringEnabled, logstashLicense$);
        return () => {
          docTitle.reset();
          unmountAppCallback();
        };
      }
    });
    this.licenseSubscription = (0, _rxjs.combineLatest)([logstashLicense$, this.capabilities$]).subscribe(([license, capabilities]) => {
      const shouldShow = license.enableLinks && capabilities.management.ingest.pipelines === true;
      if (shouldShow) {
        managementApp.enable();
      } else {
        managementApp.disable();
      }
      if (plugins.home && shouldShow) {
        // Ensure that we don't register the feature more than once
        (0, _lodash.once)(() => {
          plugins.home.featureCatalogue.register({
            id: 'management_logstash',
            title: _i18n.i18n.translate('xpack.logstash.homeFeature.logstashPipelinesTitle', {
              defaultMessage: 'Logstash Pipelines'
            }),
            description: _i18n.i18n.translate('xpack.logstash.homeFeature.logstashPipelinesDescription', {
              defaultMessage: 'Create, delete, update, and clone data ingestion pipelines.'
            }),
            icon: 'pipelineApp',
            path: '/app/management/ingest/pipelines',
            showOnHomePage: false,
            category: 'admin'
          });
        });
      }
    });
  }
  start(core) {
    this.capabilities$.next(core.application.capabilities);
  }
  stop() {
    if (this.licenseSubscription) {
      this.licenseSubscription.unsubscribe();
    }
  }
}
exports.LogstashPlugin = LogstashPlugin;