"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logViewSavedObjectRT = exports.logViewSavedObjectFieldColumnConfigurationRT = exports.logViewSavedObjectColumnConfigurationRT = exports.logViewSavedObjectAttributesRT = exports.logIndexSavedObjectReferenceRT = exports.logIndexNameSavedObjectReferenceRT = exports.logDataViewSavedObjectReferenceRT = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
var _references = require("../references");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logDataViewSavedObjectReferenceRT = exports.logDataViewSavedObjectReferenceRT = rt.type({
  type: rt.literal('data_view'),
  dataViewId: rt.string
});
const logIndexNameSavedObjectReferenceRT = exports.logIndexNameSavedObjectReferenceRT = rt.type({
  type: rt.literal('index_name'),
  indexName: rt.string
});
const logIndexSavedObjectReferenceRT = exports.logIndexSavedObjectReferenceRT = rt.union([logDataViewSavedObjectReferenceRT, logIndexNameSavedObjectReferenceRT]);
const logViewSavedObjectCommonColumnConfigurationRT = rt.strict({
  id: rt.string
});
const logViewSavedObjectTimestampColumnConfigurationRT = rt.strict({
  timestampColumn: logViewSavedObjectCommonColumnConfigurationRT
});
const logViewSavedObjectMessageColumnConfigurationRT = rt.strict({
  messageColumn: logViewSavedObjectCommonColumnConfigurationRT
});
const logViewSavedObjectFieldColumnConfigurationRT = exports.logViewSavedObjectFieldColumnConfigurationRT = rt.strict({
  fieldColumn: rt.intersection([logViewSavedObjectCommonColumnConfigurationRT, rt.strict({
    field: rt.string
  })])
});
const logViewSavedObjectColumnConfigurationRT = exports.logViewSavedObjectColumnConfigurationRT = rt.union([logViewSavedObjectTimestampColumnConfigurationRT, logViewSavedObjectMessageColumnConfigurationRT, logViewSavedObjectFieldColumnConfigurationRT]);
const logViewSavedObjectAttributesRT = exports.logViewSavedObjectAttributesRT = rt.strict({
  name: rt.string,
  description: rt.string,
  logIndices: logIndexSavedObjectReferenceRT,
  logColumns: rt.array(logViewSavedObjectColumnConfigurationRT)
});
const logViewSavedObjectRT = exports.logViewSavedObjectRT = rt.intersection([rt.type({
  id: rt.string,
  attributes: logViewSavedObjectAttributesRT,
  references: rt.array(_references.savedObjectReferenceRT)
}), rt.partial({
  version: rt.string,
  updated_at: _ioTsUtils.isoToEpochRt
})]);