"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initLogEntriesHighlightsRoute = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _configSchema = require("@kbn/config-schema");
var _http_api = require("../../../common/http_api");
var _runtime_types = require("../../../common/runtime_types");
var _serialized_query = require("../../utils/serialized_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const escapeHatch = _configSchema.schema.object({}, {
  unknowns: 'allow'
});
const initLogEntriesHighlightsRoute = ({
  framework,
  logEntries
}) => {
  framework.registerVersionedRoute({
    access: 'internal',
    method: 'post',
    path: _http_api.logEntriesV1.LOG_ENTRIES_HIGHLIGHTS_PATH
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: escapeHatch
      }
    }
  }, async (requestContext, request, response) => {
    const payload = (0, _pipeable.pipe)(_http_api.logEntriesV1.logEntriesHighlightsRequestRT.decode(request.body), (0, _Either.fold)((0, _runtime_types.throwErrors)(_boom.default.badRequest), _function.identity));
    const {
      startTimestamp,
      endTimestamp,
      logView,
      query,
      size,
      highlightTerms
    } = payload;
    let entriesPerHighlightTerm;
    if ('center' in payload) {
      entriesPerHighlightTerm = await Promise.all(highlightTerms.map(highlightTerm => logEntries.getLogEntriesAround(requestContext, logView, {
        startTimestamp,
        endTimestamp,
        query: (0, _serialized_query.parseFilterQuery)(query),
        center: payload.center,
        size,
        highlightTerm
      })));
    } else {
      let cursor;
      if ('before' in payload) {
        cursor = {
          before: payload.before
        };
      } else if ('after' in payload) {
        cursor = {
          after: payload.after
        };
      }
      entriesPerHighlightTerm = await Promise.all(highlightTerms.map(highlightTerm => logEntries.getLogEntries(requestContext, logView, {
        startTimestamp,
        endTimestamp,
        query: (0, _serialized_query.parseFilterQuery)(query),
        cursor,
        size,
        highlightTerm
      })));
    }
    return response.ok({
      body: _http_api.logEntriesV1.logEntriesHighlightsResponseRT.encode({
        data: entriesPerHighlightTerm.map(({
          entries
        }) => {
          if (entries.length > 0) {
            return {
              entries,
              topCursor: entries[0].cursor,
              bottomCursor: entries[entries.length - 1].cursor
            };
          } else {
            return {
              entries,
              topCursor: null,
              bottomCursor: null
            };
          }
        })
      })
    });
  });
};
exports.initLogEntriesHighlightsRoute = initLogEntriesHighlightsRoute;