"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsSharedPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _saved_objects = require("./saved_objects");
var _logs_shared_server = require("./logs_shared_server");
var _log_views = require("./services/log_views");
var _kibana_framework_adapter = require("./lib/adapters/framework/kibana_framework_adapter");
var _log_entries_domain = require("./lib/domains/log_entries_domain");
var _kibana_log_entries_adapter = require("./lib/adapters/log_entries/kibana_log_entries_adapter");
var _log_entries = require("./services/log_entries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogsSharedPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "libs", void 0);
    (0, _defineProperty2.default)(this, "logViews", void 0);
    (0, _defineProperty2.default)(this, "usageCollector", void 0);
    this.config = context.config.get();
    this.logger = context.logger.get();
    this.usageCollector = {};
    this.logViews = new _log_views.LogViewsService(this.logger.get('logViews'));
  }
  setup(core, plugins) {
    const framework = new _kibana_framework_adapter.KibanaFramework(core, plugins);
    const logViews = this.logViews.setup();
    if (this.config.savedObjects.logView.enabled) {
      // Conditionally register log view saved objects
      core.savedObjects.registerType(_saved_objects.logViewSavedObjectType);
    } else {
      // Register a static internal view to use as a fallback when the log view SO is not registered
      logViews.defineInternalLogView('default', {});
    }
    const domainLibs = {
      logEntries: new _log_entries_domain.LogsSharedLogEntriesDomain(new _kibana_log_entries_adapter.LogsSharedKibanaLogEntriesAdapter(framework), {
        framework,
        getStartServices: () => core.getStartServices()
      })
    };
    this.libs = {
      ...domainLibs,
      basePath: core.http.basePath,
      config: this.config,
      framework,
      getStartServices: () => core.getStartServices(),
      getUsageCollector: () => this.usageCollector,
      logger: this.logger
    };

    // Register server side APIs
    (0, _logs_shared_server.initLogsSharedServer)(this.libs);
    const logEntriesService = new _log_entries.LogEntriesService();
    logEntriesService.setup(core, plugins);
    return {
      ...domainLibs,
      logViews,
      registerUsageCollectorActions: usageCollector => {
        Object.assign(this.usageCollector, usageCollector);
      }
    };
  }
  start(core, plugins) {
    const logViews = this.logViews.start({
      savedObjects: core.savedObjects,
      dataViews: plugins.dataViews,
      elasticsearch: core.elasticsearch
    });
    return {
      logViews
    };
  }
  stop() {}
}
exports.LogsSharedPlugin = LogsSharedPlugin;