"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogViewsClient = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _rxjs = require("rxjs");
var _http_api = require("../../../common/http_api");
var _log_views = require("../../../common/http_api/log_views");
var _log_views2 = require("../../../common/log_views");
var _runtime_types = require("../../../common/runtime_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogViewsClient {
  constructor(dataViews, http, search, config) {
    this.dataViews = dataViews;
    this.http = http;
    this.search = search;
    this.config = config;
  }
  async getLogView(logViewReference) {
    if (logViewReference.type === 'log-view-inline') {
      return {
        ...logViewReference,
        origin: 'inline'
      };
    }
    const {
      logViewId
    } = logViewReference;
    const response = await this.http.get((0, _log_views.getLogViewUrl)(logViewId), {
      version: '1'
    }).catch(error => {
      throw new _log_views2.FetchLogViewError(`Failed to fetch log view "${logViewId}": ${error}`);
    });
    const {
      data
    } = (0, _runtime_types.decodeOrThrow)(_http_api.getLogViewResponsePayloadRT, message => new _log_views2.FetchLogViewError(`Failed to decode log view "${logViewId}": ${message}"`))(response);
    return data;
  }
  async getResolvedLogView(logViewReference) {
    const logView = await this.getLogView(logViewReference);
    const resolvedLogView = await this.resolveLogView(logView.id, logView.attributes);
    return resolvedLogView;
  }
  async getResolvedLogViewStatus(resolvedLogView) {
    const indexStatus = await (0, _rxjs.lastValueFrom)(this.search({
      params: {
        ignore_unavailable: true,
        allow_no_indices: true,
        index: resolvedLogView.indices,
        size: 0,
        terminate_after: 1,
        track_total_hits: 1
      }
    })).then(({
      rawResponse
    }) => {
      if (rawResponse._shards.total <= 0) {
        return 'missing';
      }
      const totalHits = decodeTotalHits(rawResponse.hits.total);
      if (typeof totalHits === 'number' ? totalHits > 0 : totalHits.value > 0) {
        return 'available';
      }
      return 'empty';
    }, err => {
      if (err.status === 404) {
        return 'missing';
      }
      throw new _log_views2.FetchLogViewStatusError(`Failed to check status of log indices of "${resolvedLogView.indices}": ${err}`);
    });
    return {
      index: indexStatus
    };
  }
  async putLogView(logViewReference, logViewAttributes) {
    if (logViewReference.type === 'log-view-inline') {
      const {
        id
      } = logViewReference;
      const attributes = (0, _runtime_types.decodeOrThrow)(rt.partial(_log_views2.logViewAttributesRT.type.props), message => new _log_views2.PutLogViewError(`Failed to decode inline log view "${id}": ${message}"`))(logViewAttributes);
      return {
        id,
        attributes: {
          ...logViewReference.attributes,
          ...attributes
        },
        origin: 'inline'
      };
    } else {
      const {
        logViewId
      } = logViewReference;
      const response = await this.http.put((0, _log_views.getLogViewUrl)(logViewId), {
        body: JSON.stringify(_http_api.putLogViewRequestPayloadRT.encode({
          attributes: logViewAttributes
        })),
        version: '1'
      }).catch(error => {
        throw new _log_views2.PutLogViewError(`Failed to write log view "${logViewId}": ${error}`);
      });
      const {
        data
      } = (0, _runtime_types.decodeOrThrow)(_http_api.getLogViewResponsePayloadRT, message => new _log_views2.PutLogViewError(`Failed to decode written log view "${logViewId}": ${message}"`))(response);
      return data;
    }
  }
  async resolveLogView(logViewId, logViewAttributes) {
    return await (0, _log_views2.resolveLogView)(logViewId, logViewAttributes, this.dataViews, this.config);
  }
}
exports.LogViewsClient = LogViewsClient;
const decodeTotalHits = (0, _runtime_types.decodeOrThrow)(rt.union([rt.number, rt.type({
  value: rt.number
})]));