"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogStreamContent = exports.LogStream = void 0;
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _log_views = require("../../../common/log_views");
var _log_stream = require("../../containers/logs/log_stream");
var _use_log_view = require("../../hooks/use_log_view");
var _log_views2 = require("../../services/log_views");
var _use_kibana_query_settings = require("../../utils/use_kibana_query_settings");
var _log_entry_flyout = require("../logging/log_entry_flyout");
var _log_text_stream = require("../logging/log_text_stream");
var _log_stream_error_boundary = require("./log_stream_error_boundary");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_THRESHOLD = 2;
const LogStream = ({
  height = 400,
  ...contentProps
}) => {
  return /*#__PURE__*/_react.default.createElement(LogStreamContainer, {
    style: {
      height
    }
  }, /*#__PURE__*/_react.default.createElement(_log_stream_error_boundary.LogStreamErrorBoundary, {
    resetOnChange: [contentProps.query]
  }, /*#__PURE__*/_react.default.createElement(LogStreamContent, contentProps)));
};
exports.LogStream = LogStream;
const LogStreamContent = ({
  logView,
  startTimestamp,
  endTimestamp,
  query,
  filters,
  center,
  highlight,
  columns,
  startDateExpression = '',
  endDateExpression = '',
  showFlyoutAction = false,
  isStreaming = false
}) => {
  const customColumns = (0, _react.useMemo)(() => columns ? convertLogColumnDefinitionToLogSourceColumnDefinition(columns) : undefined, [columns]);
  const {
    services: {
      http,
      data,
      share
    }
  } = (0, _public.useKibana)();
  if (http == null || data == null || share == null) {
    throw new Error(`<LogStream /> cannot access kibana core services.

Ensure the component is mounted within kibana-react's <KibanaContextProvider> hierarchy.
Read more at https://github.com/elastic/kibana/blob/main/src/plugins/kibana_react/README.md"
`);
  }
  const {
    openLogEntryFlyout
  } = (0, _log_entry_flyout.useLogEntryFlyout)(logView);
  const kibanaQuerySettings = (0, _use_kibana_query_settings.useKibanaQuerySettings)();
  const logViews = (0, _react.useMemo)(() => new _log_views2.LogViewsClient(data.dataViews, http, data.search.search, _log_views.defaultLogViewsStaticConfig), [data.dataViews, data.search.search, http]);
  const {
    derivedDataView,
    isLoading: isLoadingLogView,
    load: loadLogView,
    resolvedLogView
  } = (0, _use_log_view.useLogView)({
    initialLogViewReference: logView,
    logViews
  });
  const parsedQuery = (0, _react.useMemo)(() => {
    if (typeof query === 'object' && 'bool' in query) {
      return mergeBoolQueries(query, (0, _esQuery.buildEsQuery)(derivedDataView, [], filters !== null && filters !== void 0 ? filters : [], kibanaQuerySettings));
    } else {
      return (0, _esQuery.buildEsQuery)(derivedDataView, coerceToQueries(query), filters !== null && filters !== void 0 ? filters : [], kibanaQuerySettings);
    }
  }, [derivedDataView, filters, kibanaQuerySettings, query]);

  // Internal state
  const {
    entries,
    fetchEntries,
    fetchNewestEntries,
    fetchNextEntries,
    fetchPreviousEntries,
    hasMoreAfter,
    hasMoreBefore,
    lastLoadedTime,
    isLoadingMore,
    isReloading: isLoadingEntries
  } = (0, _log_stream.useLogStream)({
    logViewReference: logView,
    startTimestamp,
    endTimestamp,
    query: parsedQuery,
    center,
    columns: customColumns
  });
  const isReloading = (0, _react.useMemo)(() => isLoadingLogView || isLoadingEntries, [isLoadingEntries, isLoadingLogView]);
  const columnConfigurations = (0, _react.useMemo)(() => {
    return resolvedLogView ? customColumns !== null && customColumns !== void 0 ? customColumns : resolvedLogView.columns : [];
  }, [resolvedLogView, customColumns]);
  const streamItems = (0, _react.useMemo)(() => isReloading ? [] : entries.map(entry => ({
    kind: 'logEntry',
    logEntry: entry,
    highlights: []
  })), [entries, isReloading]);
  const prevStartTimestamp = (0, _usePrevious.default)(startTimestamp);
  const prevEndTimestamp = (0, _usePrevious.default)(endTimestamp);
  const prevFilterQuery = (0, _usePrevious.default)(parsedQuery);

  // Component lifetime
  (0, _react.useEffect)(() => {
    loadLogView();
  }, [loadLogView]);
  (0, _react.useEffect)(() => {
    const isFirstLoad = !prevStartTimestamp || !prevEndTimestamp;
    const hasQueryChanged = parsedQuery !== prevFilterQuery;
    const timerangeChanged = prevStartTimestamp !== startTimestamp || prevEndTimestamp !== endTimestamp;
    if (isFirstLoad || hasQueryChanged) {
      fetchEntries();
    }
    if (timerangeChanged) {
      if (isStreaming) {
        fetchNewestEntries();
      } else {
        fetchEntries();
      }
    }
  }, [endTimestamp, fetchEntries, fetchNewestEntries, isStreaming, parsedQuery, prevEndTimestamp, prevFilterQuery, prevStartTimestamp, startTimestamp]);

  // Pagination handler
  const handlePagination = (0, _react.useCallback)(({
    fromScroll,
    pagesBeforeStart,
    pagesAfterEnd
  }) => {
    if (!fromScroll) {
      return;
    }
    if (isLoadingMore) {
      return;
    }
    if (pagesBeforeStart < PAGE_THRESHOLD) {
      fetchPreviousEntries();
    } else if (pagesAfterEnd < PAGE_THRESHOLD) {
      fetchNextEntries();
    }
  }, [isLoadingMore, fetchPreviousEntries, fetchNextEntries]);
  return /*#__PURE__*/_react.default.createElement(_log_text_stream.ScrollableLogTextStreamView, {
    target: center ? center : entries.length ? entries[entries.length - 1].cursor : null,
    columnConfigurations: columnConfigurations,
    items: streamItems,
    scale: "medium",
    wrap: true,
    isReloading: isReloading,
    isLoadingMore: isLoadingMore,
    isStreaming: isStreaming,
    hasMoreBeforeStart: hasMoreBefore,
    hasMoreAfterEnd: hasMoreAfter,
    lastLoadedTime: lastLoadedTime,
    jumpToTarget: _lodash.noop,
    reportVisibleInterval: handlePagination,
    reloadItems: fetchEntries,
    onOpenLogEntryFlyout: showFlyoutAction ? openLogEntryFlyout : undefined,
    highlightedItem: highlight !== null && highlight !== void 0 ? highlight : null,
    currentHighlightKey: null,
    startDateExpression: startDateExpression,
    endDateExpression: endDateExpression,
    updateDateRange: _lodash.noop,
    startLiveStreaming: _lodash.noop,
    hideScrollbar: false
  });
};
exports.LogStreamContent = LogStreamContent;
const LogStreamContainer = _common.euiStyled.div`
  display: flex;
  background-color: ${props => props.theme.eui.euiColorEmptyShade};
`;
function convertLogColumnDefinitionToLogSourceColumnDefinition(columns) {
  return columns.map(column => {
    // We extract the { width, header, render } inside each block so the TS compiler uses the right type for `render`
    switch (column.type) {
      case 'timestamp':
        {
          const {
            width,
            header,
            render
          } = column;
          return {
            timestampColumn: {
              id: '___#timestamp',
              width,
              header,
              render
            }
          };
        }
      case 'message':
        {
          const {
            width,
            header,
            render
          } = column;
          return {
            messageColumn: {
              id: '___#message',
              width,
              header,
              render
            }
          };
        }
      case 'field':
        {
          const {
            width,
            header,
            render
          } = column;
          return {
            fieldColumn: {
              id: `___#${column.field}`,
              field: column.field,
              width,
              header,
              render
            }
          };
        }
    }
  });
}
const mergeBoolQueries = (firstQuery, secondQuery) => ({
  bool: {
    must: [...firstQuery.bool.must, ...secondQuery.bool.must],
    filter: [...firstQuery.bool.filter, ...secondQuery.bool.filter],
    should: [...firstQuery.bool.should, ...secondQuery.bool.should],
    must_not: [...firstQuery.bool.must_not, ...secondQuery.bool.must_not]
  }
});
const coerceToQueries = value => {
  if (value == null) {
    return [];
  } else if (typeof value === 'string') {
    return [{
      language: 'kuery',
      query: value
    }];
  } else if ('language' in value && 'query' in value) {
    return [value];
  }
  return [];
};

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
var _default = exports.default = LogStream;