"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_CONTEXT = void 0;
var _unifiedDataTable = require("@kbn/unified-data-table");
var _constants = require("../../../../common/constants");
var _data_source_selection = require("../../../../common/data_source_selection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_CONTEXT = exports.DEFAULT_CONTEXT = {
  dataSourceSelection: _data_source_selection.AllDatasetSelection.create(),
  grid: {
    columns: _constants.DEFAULT_COLUMNS,
    rows: {
      rowHeight: _unifiedDataTable.ROWS_HEIGHT_OPTIONS.single,
      rowsPerPage: _constants.DEFAULT_ROWS_PER_PAGE
    }
  },
  chart: {
    breakdownField: _constants.LOG_LEVEL_FIELD
  },
  filters: [],
  query: {
    language: 'kuery',
    query: ''
  },
  refreshInterval: {
    pause: true,
    value: 60000
  },
  time: {
    mode: 'relative',
    from: 'now-15m/m',
    to: 'now'
  },
  rows: []
};