"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogsExplorerProfileCustomizations = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _waitFor = require("xstate/lib/waitFor");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _use_kibana = require("../utils/use_kibana");
var _custom_search_bar = require("./custom_search_bar");
var _custom_unified_histogram = require("./custom_unified_histogram");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LazyCustomDataSourceFilters = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./custom_data_source_filters'))));
const LazyCustomDataSourceSelector = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./custom_data_source_selector'))));
const createLogsExplorerProfileCustomizations = ({
  core,
  plugins,
  controller
}) => async ({
  customizations,
  stateContainer
}) => {
  const {
    discoverServices,
    service
  } = controller;
  const pluginsWithOverrides = {
    ...plugins,
    ...discoverServices
  };
  const {
    data,
    dataViews,
    navigation,
    unifiedSearch
  } = pluginsWithOverrides;
  service.send('RECEIVED_STATE_CONTAINER', {
    discoverStateContainer: stateContainer
  });

  /**
   * Wait for the machine to be fully initialized to set the restored selection
   * create the DataView and set it in the stateContainer from Discover
   */
  await (0, _waitFor.waitFor)(service, state => state.matches('initialized'), {
    timeout: 30000
  });

  /**
   * Replace the DataViewPicker with a custom `DataSourceSelector` to pick integrations streams
   * Prepend the search bar with custom filter control groups depending on the selected dataset
   */
  customizations.set({
    id: 'search_bar',
    CustomDataViewPicker: () => {
      const KibanaContextProviderForPlugin = (0, _use_kibana.useKibanaContextForPluginProvider)(core, plugins);
      return /*#__PURE__*/_react.default.createElement(KibanaContextProviderForPlugin, null, /*#__PURE__*/_react.default.createElement(LazyCustomDataSourceSelector, {
        controller: controller,
        core: core,
        datasetsClient: controller.datasetsClient,
        dataViews: dataViews,
        logsExplorerControllerStateService: service
      }));
    },
    PrependFilterBar: () => /*#__PURE__*/_react.default.createElement(LazyCustomDataSourceFilters, {
      logsExplorerControllerStateService: service,
      data: data
    }),
    CustomSearchBar: (0, _custom_search_bar.createCustomSearchBar)({
      data,
      navigation,
      unifiedSearch
    })
  });
  customizations.set({
    id: 'data_table',
    logsEnabled: true,
    customControlColumnsConfiguration: await Promise.resolve().then(() => _interopRequireWildcard(require('./custom_control_column'))).then(module => module.createCustomControlColumnsConfiguration(service))
  });
  customizations.set({
    id: 'field_list',
    logsFieldsEnabled: true
  });

  // Fix bug where filtering on histogram does not work
  customizations.set((0, _custom_unified_histogram.createCustomUnifiedHistogram)(data));

  /**
   * Hide New, Open and Save settings to prevent working with saved views.
   */
  customizations.set({
    id: 'top_nav',
    defaultMenu: {
      newItem: {
        disabled: true
      },
      openItem: {
        disabled: true
      },
      saveItem: {
        disabled: true
      }
    },
    defaultBadges: {
      unsavedChangesBadge: {
        disabled: true
      }
    }
  });

  /**
   * Flyout customization.
   * The latest changes moved the implementation of the flyout overview tab into the unified_doc_viewer presets.
   * To keep control over the overview tab and enable it only on the Logs Explorer,
   * the docViewsRegistry is updated to allow enable/disable of any doc view.
   * In a close future, when the contextual awareness for Discover will be in place,
   * this configuration will be moved into a flavored logs experience directly defined in Discover.
   */
  customizations.set({
    id: 'flyout',
    size: 650,
    title: _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.title', {
      defaultMessage: 'Log details'
    }),
    actions: {
      defaultActions: {
        viewSingleDocument: {
          disabled: true
        },
        viewSurroundingDocument: {
          disabled: true
        }
      }
    },
    docViewsRegistry: registry => {
      registry.enableById('doc_view_logs_overview');
      return registry;
    }
  });
  return () => {};
};
exports.createLogsExplorerProfileCustomizations = createLogsExplorerProfileCustomizations;