"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/controls-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _use_control_panels = require("../hooks/use_control_panels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_SOURCE_FILTERS_CUSTOMIZATION_ID = 'dataSourceFiltersCustomization';
const CustomDataSourceFilters = ({
  logsExplorerControllerStateService,
  data
}) => {
  const {
    getInitialInput,
    setControlGroupAPI,
    query,
    filters,
    timeRange
  } = (0, _use_control_panels.useControlPanels)(logsExplorerControllerStateService, data);
  return /*#__PURE__*/_react.default.createElement(ControlGroupContainer, {
    "data-test-subj": DATA_SOURCE_FILTERS_CUSTOMIZATION_ID
  }, /*#__PURE__*/_react.default.createElement(_public.ControlGroupRenderer, {
    ref: setControlGroupAPI,
    getCreationOptions: getInitialInput,
    query: query,
    filters: filters !== null && filters !== void 0 ? filters : [],
    timeRange: timeRange
  }));
};
const ControlGroupContainer = _common.euiStyled.div`
[class*='options_list_popover_footer--OptionsListPopoverFooter'] {
  display: none;
}

[data-test-subj='controls-group-wrapper'] {
  min-height: 32px;
}

[data-test-subj='optionsListControl__sortingOptionsButton'] {
  display: none;
}

[id^='control-popover'] .euiPopoverTitle {
  display: none;
}

  .euiFlexGroup.controlGroup {
    min-height: 32px;
  }

  .euiFormControlLayout.euiFormControlLayout--group.controlFrame__formControlLayout {
    height: 32px;

    & .euiFormLabel.controlFrame__formControlLayoutLabel {
      padding: 8px !important;
    }

    .euiButtonEmpty.euiFilterButton {
      height: 32px;
    }
  }

  .euiText.errorEmbeddableCompact__button {
    padding: 8px;

    .euiLink {
      display: flex;
      gap: 8px;
    }
  }
`;

// eslint-disable-next-line import/no-default-export
var _default = exports.default = CustomDataSourceFilters;
module.exports = exports.default;