"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogsExplorerControllerFactory = void 0;
var _xstateUtils = require("@kbn/xstate-utils");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _rxjs = require("rxjs");
var _xstate = require("xstate");
var _datasets = require("../services/datasets");
var _logs_explorer_controller = require("../state_machines/logs_explorer_controller");
var _custom_data_service = require("./custom_data_service");
var _custom_ui_settings_service = require("./custom_ui_settings_service");
var _custom_url_state_storage = require("./custom_url_state_storage");
var _public_state = require("./public_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createLogsExplorerControllerFactory = ({
  core,
  plugins
}) => async ({
  customizations = {},
  initialState
}) => {
  const {
    data,
    dataViews
  } = plugins;
  const datasetsClient = new _datasets.DatasetsService().start({
    http: core.http
  }).client;
  const customMemoryHistory = (0, _custom_url_state_storage.createDiscoverMemoryHistory)();
  const customMemoryUrlStateStorage = (0, _custom_url_state_storage.createMemoryUrlStateStorage)(customMemoryHistory);
  const customUiSettings = (0, _custom_ui_settings_service.createUiSettingsServiceProxy)(core.uiSettings);
  const customData = (0, _custom_data_service.createDataServiceProxy)({
    data,
    http: core.http,
    uiSettings: customUiSettings
  });
  const discoverServices = {
    data: customData,
    history: customMemoryHistory,
    uiSettings: customUiSettings,
    filterManager: customData.query.filterManager,
    timefilter: customData.query.timefilter.timefilter,
    urlStateStorage: customMemoryUrlStateStorage
  };
  const initialContext = (0, _public_state.getContextFromPublicState)(initialState !== null && initialState !== void 0 ? initialState : {});
  const publicEvents$ = new _rxjs.Subject();
  const machine = (0, _logs_explorer_controller.createLogsExplorerControllerStateMachine)({
    datasetsClient,
    dataViews,
    events: customizations.events,
    initialContext,
    query: discoverServices.data.query,
    toasts: core.notifications.toasts,
    uiSettings: customUiSettings,
    publicEvents$
  });
  const service = (0, _xstate.interpret)(machine, {
    devTools: (0, _xstateUtils.getDevToolsOptions)()
  });
  const logsExplorerState$ = (0, _rxjs.from)(service).pipe((0, _rxjs.map)(({
    context
  }) => (0, _public_state.getPublicStateFromContext)(context)), (0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default), (0, _rxjs.shareReplay)(1));
  return {
    actions: {},
    customizations,
    datasetsClient,
    discoverServices,
    event$: publicEvents$,
    service,
    state$: logsExplorerState$,
    stateMachine: machine
  };
};
exports.createLogsExplorerControllerFactory = createLogsExplorerControllerFactory;