"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPopoverButtonStyles = exports.createUncategorizedStatusItem = exports.createIntegrationStatusItem = exports.createDataViewsStatusItem = exports.createAllLogsItem = exports.buildIntegrationsTree = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/fleet-plugin/public");
var _datasets = require("../../../common/datasets");
var _constants = require("./constants");
var _list_status = _interopRequireDefault(require("./sub_components/list_status"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPopoverButtonStyles = ({
  fullWidth
}) => ({
  maxWidth: fullWidth ? undefined : _constants.DATA_SOURCE_SELECTOR_WIDTH
});
exports.getPopoverButtonStyles = getPopoverButtonStyles;
/**
 * The `EuiContextMenu` component receives a list of panels,
 * each one with a pointer id which is used as a reference for the items to know
 * what panel they refer to.
 * This helper function, starting from a list of integrations,
 * generate the necessary item entries for each integration,
 * and also create a related panel that render the list of data streams for the integration.
 */
const buildIntegrationsTree = ({
  integrations,
  onDatasetSelected,
  spyRef
}) => {
  return integrations.reduce((integrationsTree, integration, pos) => {
    const {
      name,
      title,
      version,
      datasets,
      icons
    } = integration;
    const isLastIntegration = pos === integrations.length - 1;
    integrationsTree.items.push({
      name: title,
      icon: /*#__PURE__*/_react.default.createElement(_public.PackageIcon, {
        packageName: name,
        version: version,
        size: "m",
        icons: icons,
        tryApi: true
      }),
      'data-test-subj': integration.id,
      panel: integration.id,
      ...(isLastIntegration && {
        buttonRef: spyRef
      })
    });
    integrationsTree.panels.push({
      id: integration.id,
      title,
      width: _constants.DATA_SOURCE_SELECTOR_WIDTH,
      items: datasets.map(dataset => ({
        name: dataset.title,
        onClick: () => onDatasetSelected(dataset)
      }))
    });
    return integrationsTree;
  }, {
    items: [],
    panels: []
  });
};
exports.buildIntegrationsTree = buildIntegrationsTree;
const createAllLogsItem = () => {
  const allLogs = _datasets.Dataset.createAllLogsDataset();
  return {
    'data-test-subj': 'dataSourceSelectorShowAllLogs',
    iconType: allLogs.iconType,
    name: allLogs.title
  };
};
exports.createAllLogsItem = createAllLogsItem;
const createIntegrationStatusItem = props => {
  return {
    disabled: true,
    name: /*#__PURE__*/_react.default.createElement(_list_status.default, (0, _extends2.default)({
      key: "integrationStatusItem",
      description: _constants.noIntegrationsDescriptionLabel,
      title: _constants.noIntegrationsLabel
    }, props))
  };
};
exports.createIntegrationStatusItem = createIntegrationStatusItem;
const createUncategorizedStatusItem = props => {
  return {
    disabled: true,
    name: /*#__PURE__*/_react.default.createElement(_list_status.default, (0, _extends2.default)({
      key: "uncategorizedStatusItem",
      description: _constants.noDatasetsDescriptionLabel,
      title: _constants.noDatasetsLabel
    }, props))
  };
};
exports.createUncategorizedStatusItem = createUncategorizedStatusItem;
const createDataViewsStatusItem = props => {
  return {
    disabled: true,
    name: /*#__PURE__*/_react.default.createElement(_list_status.default, (0, _extends2.default)({
      key: "dataViewsStatusItem",
      description: _constants.noDataViewsDescriptionLabel,
      title: _constants.noDataViewsLabel
    }, props))
  };
};
exports.createDataViewsStatusItem = createDataViewsStatusItem;