"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowAllLogsButton = exports.SelectorFooter = exports.ESQLButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _routerUtils = require("@kbn/router-utils");
var _utils = require("../utils");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectorFooter = props => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    "data-test-subj": "dataSourceSelectorSearchFooter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, props)));
};
exports.SelectorFooter = SelectorFooter;
const ShowAllLogsButton = ({
  isSelected,
  onClick
}) => {
  const allLogs = (0, _utils.createAllLogsItem)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": allLogs['data-test-subj'],
    onClick: onClick,
    size: "s",
    iconType: isSelected ? 'check' : allLogs.iconType,
    flush: "left"
  }, _constants.showAllLogsLabel));
};
exports.ShowAllLogsButton = ShowAllLogsButton;
const ESQLButton = props => {
  const linkProps = (0, _routerUtils.getRouterLinkProps)(props);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, linkProps, {
    color: "success",
    size: "s",
    "data-test-subj": "esqlLink"
  }), _constants.tryEsql));
};
exports.ESQLButton = ESQLButton;