"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewDescriptor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _dataViewUtils = require("@kbn/data-view-utils");
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOGS_ALLOWED_LIST = [(0, _dataViewUtils.createRegExpPatternFrom)(_discoverUtils.DEFAULT_ALLOWED_LOGS_BASE_PATTERNS)
// Add more strings or regex patterns as needed
];
class DataViewDescriptor {
  constructor(dataViewDescriptor) {
    (0, _defineProperty2.default)(this, "id", void 0);
    (0, _defineProperty2.default)(this, "dataType", void 0);
    (0, _defineProperty2.default)(this, "kibanaSpaces", void 0);
    (0, _defineProperty2.default)(this, "name", void 0);
    (0, _defineProperty2.default)(this, "title", void 0);
    (0, _defineProperty2.default)(this, "type", void 0);
    this.id = dataViewDescriptor.id;
    this.dataType = dataViewDescriptor.dataType;
    this.kibanaSpaces = dataViewDescriptor.kibanaSpaces;
    this.name = dataViewDescriptor.name;
    this.title = dataViewDescriptor.title;
    this.type = dataViewDescriptor.type;
  }
  getFullTitle() {
    return this.name;
  }
  toDataviewSpec() {
    return {
      id: this.id,
      name: this.name,
      title: this.title
    };
  }
  toPlain() {
    return {
      id: this.id,
      dataType: this.dataType,
      name: this.name,
      title: this.title
    };
  }
  testAgainstAllowedList(allowedList) {
    return this.title ? (0, _dataViewUtils.testPatternAgainstAllowedList)([(0, _dataViewUtils.createRegExpPatternFrom)(allowedList)])(this.title) : false;
  }
  static create({
    id,
    namespaces,
    title,
    type,
    name
  }) {
    const nameWithFallbackTitle = name !== null && name !== void 0 ? name : title;
    const dataType = title ? _extractDataType.call(DataViewDescriptor, title) : 'unresolved';
    const kibanaSpaces = namespaces;
    return new DataViewDescriptor({
      id,
      dataType,
      kibanaSpaces,
      name: nameWithFallbackTitle,
      title,
      type
    });
  }
  isLogsDataType() {
    return this.dataType === 'logs';
  }
  isUnknownDataType() {
    return this.dataType === 'unknown';
  }
  isUnresolvedDataType() {
    return this.dataType === 'unresolved';
  }
}
exports.DataViewDescriptor = DataViewDescriptor;
function _extractDataType(title) {
  if ((0, _dataViewUtils.testPatternAgainstAllowedList)(LOGS_ALLOWED_LIST)(title)) {
    return 'logs';
  }
  return 'unknown';
}