"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hydrateDataSourceSelection = void 0;
var _all_dataset_selection = require("./all_dataset_selection");
var _data_view_selection = require("./data_view_selection");
var _single_dataset_selection = require("./single_dataset_selection");
var _unresolved_dataset_selection = require("./unresolved_dataset_selection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hydrateDataSourceSelection = dataSourceSelection => {
  if (dataSourceSelection.selectionType === 'all') {
    return _all_dataset_selection.AllDatasetSelection.create();
  } else if (dataSourceSelection.selectionType === 'single') {
    return _single_dataset_selection.SingleDatasetSelection.fromSelection(dataSourceSelection.selection);
  } else if (dataSourceSelection.selectionType === 'dataView') {
    return _data_view_selection.DataViewSelection.fromSelection(dataSourceSelection.selection);
  } else {
    return _unresolved_dataset_selection.UnresolvedDatasetSelection.fromSelection(dataSourceSelection.selection);
  }
};
exports.hydrateDataSourceSelection = hydrateDataSourceSelection;