"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogErrorRate = getLogErrorRate;
exports.getLogRatePerMinute = getLogRatePerMinute;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLogRatePerMinute({
  logCount,
  timeFrom,
  timeTo
}) {
  const durationAsMinutes = (timeTo - timeFrom) / 1000 / 60;
  return logCount / durationAsMinutes;
}
function getLogErrorRate({
  logCount,
  logErrorCount = 0
}) {
  return logErrorCount / logCount;
}