"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BuilderEntryItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _securitysolutionAutocomplete = require("@kbn/securitysolution-autocomplete");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _empty_value = require("../../../common/empty_value");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  overflow: hidden;
`;
const BuilderEntryItem = ({
  allowLargeValueLists = false,
  autocompleteService,
  entry,
  httpService,
  indexPattern,
  osTypes,
  listType,
  onChange,
  onlyShowListOperators = false,
  setErrorsExist,
  setWarningsExist,
  showLabel,
  isDisabled = false,
  operatorsList,
  allowCustomOptions = false,
  getExtendedFields,
  exceptionItemIndex,
  showValueListModal
}) => {
  var _entry$field3;
  const sPaddingSize = (0, _eui.useEuiPaddingSize)('s');
  const handleError = (0, _react.useCallback)(err => {
    setErrorsExist({
      [entry.id]: err
    });
  }, [setErrorsExist, entry.id]);
  const handleWarning = (0, _react.useCallback)(warn => {
    setWarningsExist(warn);
  }, [setWarningsExist]);
  const handleFieldChange = (0, _react.useCallback)(([newField]) => {
    const {
      updatedEntry,
      index
    } = (0, _securitysolutionListUtils.getEntryOnFieldChange)(entry, newField);
    onChange(updatedEntry, index);
  }, [onChange, entry]);
  const handleOperatorChange = (0, _react.useCallback)(([newOperator]) => {
    const {
      updatedEntry,
      index
    } = (0, _securitysolutionListUtils.getEntryOnOperatorChange)(entry, newOperator);
    handleError(false);
    handleWarning(false);
    onChange(updatedEntry, index);
  }, [onChange, entry, handleError, handleWarning]);
  const handleFieldMatchValueChange = (0, _react.useCallback)(newField => {
    const {
      updatedEntry,
      index
    } = (0, _securitysolutionListUtils.getEntryOnMatchChange)(entry, newField);
    onChange(updatedEntry, index);
  }, [onChange, entry]);
  const handleFieldMatchAnyValueChange = (0, _react.useCallback)(newField => {
    const {
      updatedEntry,
      index
    } = (0, _securitysolutionListUtils.getEntryOnMatchAnyChange)(entry, newField);
    onChange(updatedEntry, index);
  }, [onChange, entry]);
  const handleFieldWildcardValueChange = (0, _react.useCallback)(newField => {
    const {
      updatedEntry,
      index
    } = (0, _securitysolutionListUtils.getEntryOnWildcardChange)(entry, newField);
    onChange(updatedEntry, index);
  }, [onChange, entry]);
  const handleFieldListValueChange = (0, _react.useCallback)(newField => {
    const {
      updatedEntry,
      index
    } = (0, _securitysolutionListUtils.getEntryOnListChange)(entry, newField);
    onChange(updatedEntry, index);
  }, [onChange, entry]);
  const [extendedField, setExtendedField] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    var _entry$field;
    if (!((_entry$field = entry.field) !== null && _entry$field !== void 0 && _entry$field.name)) {
      setExtendedField(null);
    }
    const fetchExtendedField = async () => {
      var _entry$field2;
      const fieldName = (_entry$field2 = entry.field) === null || _entry$field2 === void 0 ? void 0 : _entry$field2.name;
      if (getExtendedFields && fieldName) {
        var _extendedFields$find;
        const extendedFields = await getExtendedFields([fieldName]);
        const field = (_extendedFields$find = extendedFields.find(f => f.name === fieldName)) !== null && _extendedFields$find !== void 0 ? _extendedFields$find : null;
        setExtendedField(field);
      }
    };
    fetchExtendedField();
  }, [(_entry$field3 = entry.field) === null || _entry$field3 === void 0 ? void 0 : _entry$field3.name, getExtendedFields]);
  const isFieldComponentDisabled = (0, _react.useMemo)(() => isDisabled || !allowCustomOptions && (indexPattern == null || indexPattern != null && indexPattern.fields.length === 0), [isDisabled, indexPattern, allowCustomOptions]);
  const renderFieldInput = (0, _react.useCallback)(isFirst => {
    const filteredIndexPatterns = (0, _securitysolutionListUtils.getFilteredIndexPatterns)(indexPattern, entry);
    const comboBox = /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.FieldComponent, {
      placeholder: entry.nested != null ? i18n.EXCEPTION_FIELD_NESTED_PLACEHOLDER : i18n.EXCEPTION_FIELD_PLACEHOLDER,
      indexPattern: filteredIndexPatterns,
      selectedField: entry.field,
      "aria-label": i18n.EXCEPTION_ITEM_ARIA_LABEL(i18n.FIELD, exceptionItemIndex, entry.entryIndex),
      isClearable: false,
      isLoading: false,
      isDisabled: isDisabled || indexPattern == null,
      onChange: handleFieldChange,
      acceptsCustomOptions: entry.nested == null && allowCustomOptions,
      "data-test-subj": "exceptionBuilderEntryField",
      showMappingConflicts: true
    });
    const warningIconCss = {
      marginRight: `${sPaddingSize}`
    };
    const getMappingConflictsWarning = () => {
      if (!extendedField) {
        return null;
      }
      const conflictsInfo = (0, _securitysolutionListUtils.getMappingConflictsInfo)(extendedField);
      if (!conflictsInfo) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
        id: `${entry.id}`,
        buttonContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          "data-test-subj": "mappingConflictsAccordionIcon",
          tabIndex: 0,
          type: "warning",
          size: "s",
          css: warningIconCss
        }), i18n.FIELD_CONFLICT_INDICES_WARNING_DESCRIPTION),
        arrowDisplay: "none",
        "data-test-subj": "mappingConflictsAccordion"
      }, /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "mappingConflictsDescription"
      }, conflictsInfo.map((info, idx) => {
        const groupDetails = info.groupedIndices.map(({
          name,
          count
        }) => `${count > 1 ? i18n.CONFLICT_MULTIPLE_INDEX_DESCRIPTION(name, count) : name}`);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          key: `${idx}`
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "s"
        }), `${info.totalIndexCount > 1 ? i18n.CONFLICT_MULTIPLE_INDEX_DESCRIPTION(info.type, info.totalIndexCount) : info.type}: ${groupDetails.join(', ')}`);
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }))));
    };
    const customOptionText = entry.nested == null && allowCustomOptions ? i18n.CUSTOM_COMBOBOX_OPTION_TEXT : undefined;
    const helpText = (extendedField === null || extendedField === void 0 ? void 0 : extendedField.conflictDescriptions) == null ? customOptionText : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, customOptionText, getMappingConflictsWarning());
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: isFirst ? i18n.FIELD : '',
      helpText: helpText,
      "data-test-subj": "exceptionBuilderEntryFieldFormRow"
    }, comboBox);
  }, [indexPattern, entry, exceptionItemIndex, isDisabled, handleFieldChange, allowCustomOptions, sPaddingSize, extendedField]);
  const renderOperatorInput = isFirst => {
    // for event filters forms
    // show extra operators for wildcards when field supports matches
    const doesFieldSupportMatches = entry.field !== undefined && (0, _securitysolutionListUtils.fieldSupportsMatches)(entry.field);
    const isEventFilterList = listType === 'endpoint_events';
    const augmentedOperatorsList = operatorsList && doesFieldSupportMatches && isEventFilterList ? operatorsList : operatorsList === null || operatorsList === void 0 ? void 0 : operatorsList.filter(operator => operator.type !== _securitysolutionIoTsListTypes.ListOperatorTypeEnum.WILDCARD);
    const operatorOptions = augmentedOperatorsList ? augmentedOperatorsList : onlyShowListOperators ? _securitysolutionListUtils.EXCEPTION_OPERATORS_ONLY_LISTS : (0, _securitysolutionListUtils.getOperatorOptions)(entry, listType, entry.field != null && entry.field.type === 'boolean', isFirst);
    const comboBox = /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.OperatorComponent, {
      placeholder: i18n.EXCEPTION_OPERATOR_PLACEHOLDER,
      selectedField: entry.field,
      operator: entry.operator,
      isDisabled: isFieldComponentDisabled,
      operatorOptions: operatorOptions,
      isLoading: false,
      isClearable: false,
      onChange: handleOperatorChange,
      "aria-label": i18n.EXCEPTION_ITEM_ARIA_LABEL(i18n.OPERATOR, exceptionItemIndex, entry.entryIndex),
      "data-test-subj": "exceptionBuilderEntryOperator"
    });
    if (isFirst) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: i18n.OPERATOR,
        "data-test-subj": "exceptionBuilderEntryFieldFormRow"
      }, comboBox);
    } else {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: '',
        "data-test-subj": "exceptionBuilderEntryFieldFormRow"
      }, comboBox);
    }
  };

  // show warning when a wildcard is detected with the IS operator
  const getWildcardWithIsOperatorWarning = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lists.exceptions.builder.exceptionIsOperator.warningMessage.incorrectWildCardUsage",
      defaultMessage: "Change the operator to 'matches' to ensure wildcards run properly."
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "iInCircle",
      content: i18n.WILDCARD_WITH_IS_OPERATOR_TOOLTIP
    }));
  };

  // show this when wildcard with matches operator
  const getWildcardPerformanceWarningInfo = precedingWarning => {
    return /*#__PURE__*/_react.default.createElement("p", null, precedingWarning, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "iInCircle",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.lists.exceptions.builder.exceptionMatchesOperator.warningMessage.wildcardInFilepath",
        defaultMessage: "To make a more efficient event filter, use multiple conditions and make them as specific as possible when using wildcards in the values. For instance, adding a process.name or file.name field. Creating event filters with both `matches` and `does not match` operators may significantly decrease performance."
      }),
      size: "m"
    }));
  };

  // eslint-disable-next-line complexity
  const getFieldValueComboBox = (type, isFirst) => {
    var _entry$correspondingK, _entry$correspondingK2;
    const ariaLabel = i18n.EXCEPTION_ITEM_ARIA_LABEL(i18n.VALUE, exceptionItemIndex, entry.entryIndex);
    switch (type) {
      case _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH:
        const value = typeof entry.value === 'string' ? entry.value : undefined;
        const fieldMatchWarning = /[*?]/.test(value !== null && value !== void 0 ? value : '') ? getWildcardWithIsOperatorWarning() : undefined;
        return /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.AutocompleteFieldMatchComponent, {
          autocompleteService: autocompleteService,
          rowLabel: isFirst ? i18n.VALUE : undefined,
          placeholder: i18n.EXCEPTION_FIELD_VALUE_PLACEHOLDER,
          selectedField: (_entry$correspondingK = entry.correspondingKeywordField) !== null && _entry$correspondingK !== void 0 ? _entry$correspondingK : entry.field,
          selectedValue: value,
          isDisabled: isFieldComponentDisabled,
          isLoading: false,
          isClearable: false,
          indexPattern: indexPattern,
          onError: handleError,
          onWarning: handleWarning,
          warning: fieldMatchWarning,
          onChange: handleFieldMatchValueChange,
          isRequired: true,
          "data-test-subj": "exceptionBuilderEntryFieldMatch",
          "aria-label": ariaLabel
        });
      case _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY:
        const values = Array.isArray(entry.value) ? entry.value : [];
        return /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.AutocompleteFieldMatchAnyComponent, {
          autocompleteService: autocompleteService,
          rowLabel: isFirst ? i18n.VALUE : undefined,
          placeholder: i18n.EXCEPTION_FIELD_VALUE_PLACEHOLDER,
          selectedField: entry.correspondingKeywordField != null ? entry.correspondingKeywordField : entry.field,
          selectedValue: values,
          isDisabled: isFieldComponentDisabled,
          isLoading: false,
          isClearable: false,
          indexPattern: indexPattern,
          onError: handleError,
          onChange: handleFieldMatchAnyValueChange,
          isRequired: true,
          "aria-label": ariaLabel,
          "data-test-subj": "exceptionBuilderEntryFieldMatchAny"
        });
      case _securitysolutionIoTsListTypes.ListOperatorTypeEnum.WILDCARD:
        const wildcardValue = typeof entry.value === 'string' ? entry.value : undefined;
        let actualWarning;
        if (listType !== 'detection' && listType !== 'rule_default') {
          var _entry$field4;
          let os = _securitysolutionUtils.OperatingSystem.WINDOWS;
          if (osTypes) {
            [os] = osTypes;
          }
          const warning = (0, _securitysolutionUtils.validatePotentialWildcardInput)({
            field: (_entry$field4 = entry.field) === null || _entry$field4 === void 0 ? void 0 : _entry$field4.name,
            os,
            value: wildcardValue
          });
          actualWarning = warning === _securitysolutionUtils.WILDCARD_WARNING ? getWildcardPerformanceWarningInfo(warning) : warning;
        }
        return /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.AutocompleteFieldWildcardComponent, {
          autocompleteService: autocompleteService,
          "data-test-subj": "exceptionBuilderEntryFieldWildcard",
          isRequired: true,
          isDisabled: isFieldComponentDisabled,
          isLoading: false,
          isClearable: false,
          indexPattern: indexPattern,
          onError: handleError,
          onChange: handleFieldWildcardValueChange,
          onWarning: handleWarning,
          warning: actualWarning,
          placeholder: i18n.EXCEPTION_FIELD_VALUE_PLACEHOLDER,
          rowLabel: isFirst ? i18n.VALUE : undefined,
          selectedField: (_entry$correspondingK2 = entry.correspondingKeywordField) !== null && _entry$correspondingK2 !== void 0 ? _entry$correspondingK2 : entry.field,
          selectedValue: wildcardValue,
          "aria-label": ariaLabel
        });
      case _securitysolutionIoTsListTypes.ListOperatorTypeEnum.LIST:
        const id = typeof entry.value === 'string' ? entry.value : undefined;
        return /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.AutocompleteFieldListsComponent, {
          httpService: httpService,
          rowLabel: isFirst ? i18n.VALUE : undefined,
          selectedField: entry.field,
          placeholder: i18n.EXCEPTION_FIELD_LISTS_PLACEHOLDER,
          selectedValue: id,
          isLoading: false,
          isDisabled: isFieldComponentDisabled,
          isClearable: false,
          onChange: handleFieldListValueChange,
          "data-test-subj": "exceptionBuilderEntryFieldList",
          allowLargeValueLists: allowLargeValueLists,
          "aria-label": ariaLabel,
          showValueListModal: showValueListModal
        });
      case _securitysolutionIoTsListTypes.ListOperatorTypeEnum.EXISTS:
        return /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.AutocompleteFieldExistsComponent, {
          rowLabel: isFirst ? i18n.VALUE : undefined,
          placeholder: (0, _empty_value.getEmptyValue)(),
          "data-test-subj": "exceptionBuilderEntryFieldExists",
          "aria-label": ariaLabel
        });
      default:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    }
  };
  const renderFieldValueInput = (isFirst, entryType) => getFieldValueComboBox(entryType, isFirst);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "flexStart",
    className: "exceptionItemEntryContainer",
    "data-test-subj": "exceptionItemEntryContainer"
  }, /*#__PURE__*/_react.default.createElement(FieldFlexItem, {
    grow: 4
  }, renderFieldInput(showLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderOperatorInput(showLabel)), /*#__PURE__*/_react.default.createElement(FieldFlexItem, {
    grow: 5
  }, renderFieldValueInput(showLabel, entry.nested === 'parent' ? _securitysolutionIoTsListTypes.ListOperatorTypeEnum.EXISTS : entry.operator.type)));
};
exports.BuilderEntryItem = BuilderEntryItem;
BuilderEntryItem.displayName = 'BuilderEntryItem';