"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLinksAttributeService = getLinksAttributeService;
var _persistable_state = require("../../common/persistable_state");
var _kibana_services = require("./kibana_services");
var _content_management = require("../content_management");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let linksAttributeService = null;
function getLinksAttributeService() {
  if (linksAttributeService) return linksAttributeService;
  linksAttributeService = _kibana_services.embeddableService.getAttributeService(_common.CONTENT_ID, {
    saveMethod: async (attributes, savedObjectId) => {
      const {
        attributes: updatedAttributes,
        references
      } = (0, _persistable_state.extractReferences)({
        attributes,
        references: attributes.references
      });
      const {
        item: {
          id
        }
      } = await (savedObjectId ? _content_management.linksClient.update({
        id: savedObjectId,
        data: updatedAttributes,
        options: {
          references
        }
      }) : _content_management.linksClient.create({
        data: updatedAttributes,
        options: {
          references
        }
      }));
      return {
        id
      };
    },
    unwrapMethod: async savedObjectId => {
      const {
        item: savedObject,
        meta: {
          outcome,
          aliasPurpose,
          aliasTargetId
        }
      } = await _content_management.linksClient.get(savedObjectId);
      if (savedObject.error) throw savedObject.error;
      const {
        attributes
      } = (0, _persistable_state.injectReferences)(savedObject);
      return {
        attributes,
        metaInfo: {
          sharingSavedObjectProps: {
            aliasTargetId,
            outcome,
            aliasPurpose,
            sourceId: savedObjectId
          }
        }
      };
    },
    checkForDuplicateTitle: props => {
      return (0, _content_management.checkForDuplicateTitle)({
        title: props.newTitle,
        copyOnSave: false,
        lastSavedTitle: '',
        isTitleDuplicateConfirmed: props.isTitleDuplicateConfirmed,
        onTitleDuplicate: props.onTitleDuplicate
      });
    }
  });
  return linksAttributeService;
}