"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksPlugin = void 0;
var _common = require("../common");
var _links_strings = require("./components/links_strings");
var _links_content_management_client = require("./content_management/links_content_management_client");
var _embeddable = require("./embeddable");
var _kibana_services = require("./services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class LinksPlugin {
  constructor() {}
  setup(core, plugins) {
    core.getStartServices().then(([_, deps]) => {
      const linksFactory = new _embeddable.LinksFactoryDefinition();
      plugins.embeddable.registerEmbeddableFactory(_common.CONTENT_ID, linksFactory);
      plugins.contentManagement.registry.register({
        id: _common.CONTENT_ID,
        version: {
          latest: _common.LATEST_VERSION
        },
        name: _common.APP_NAME
      });
      const getExplicitInput = async ({
        savedObjectId,
        parent
      }) => {
        try {
          await linksFactory.getExplicitInput({
            savedObjectId
          }, parent);
        } catch {
          // swallow any errors - this just means that the user cancelled editing
        }
        return;
      };
      plugins.visualizations.registerAlias({
        disableCreate: true,
        // do not allow creation through visualization listing page
        name: _common.CONTENT_ID,
        title: _common.APP_NAME,
        icon: _common.APP_ICON,
        description: _links_strings.LinksStrings.getDescription(),
        stage: 'production',
        appExtensions: {
          visualizations: {
            docTypes: [_common.CONTENT_ID],
            searchFields: ['title^3'],
            client: _links_content_management_client.getLinksClient,
            toListItem(linkItem) {
              const {
                id,
                type,
                updatedAt,
                attributes
              } = linkItem;
              const {
                title,
                description
              } = attributes;
              return {
                id,
                title,
                editor: {
                  onEdit: savedObjectId => getExplicitInput({
                    savedObjectId
                  })
                },
                description,
                updatedAt,
                icon: _common.APP_ICON,
                typeTitle: _common.APP_NAME,
                stage: 'production',
                savedObjectType: type
              };
            }
          }
        }
      });
    });
  }
  start(core, plugins) {
    (0, _kibana_services.setKibanaServices)(core, plugins);
    return {};
  }
  stop() {}
}
exports.LinksPlugin = LinksPlugin;