"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksLayoutInfo = exports.LinkInfo = void 0;
var _content_management = require("../../common/content_management");
var _dashboard_link_strings = require("../components/dashboard_link/dashboard_link_strings");
var _external_link_strings = require("../components/external_link/external_link_strings");
var _links_strings = require("../components/links_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LinksLayoutInfo = exports.LinksLayoutInfo = {
  [_content_management.LINKS_HORIZONTAL_LAYOUT]: {
    displayName: _links_strings.LinksStrings.editor.panelEditor.getHorizontalLayoutLabel()
  },
  [_content_management.LINKS_VERTICAL_LAYOUT]: {
    displayName: _links_strings.LinksStrings.editor.panelEditor.getVerticalLayoutLabel()
  }
};
const LinkInfo = exports.LinkInfo = {
  [_content_management.DASHBOARD_LINK_TYPE]: {
    icon: 'dashboardApp',
    type: _dashboard_link_strings.DashboardLinkStrings.getType(),
    displayName: _dashboard_link_strings.DashboardLinkStrings.getDisplayName(),
    description: _dashboard_link_strings.DashboardLinkStrings.getDescription()
  },
  [_content_management.EXTERNAL_LINK_TYPE]: {
    icon: 'link',
    type: _external_link_strings.ExternalLinkStrings.getType(),
    displayName: _external_link_strings.ExternalLinkStrings.getDisplayName(),
    description: _external_link_strings.ExternalLinkStrings.getDescription()
  }
};

/**
 *  Links embeddable redux state
 */