"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLinksAttributes = exports.useLinks = void 0;
var _react = require("react");
var _links_embeddable = require("../embeddable/links_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useLinks = () => {
  const linksEmbeddable = (0, _react.useContext)(_links_embeddable.LinksContext);
  if (linksEmbeddable == null) {
    throw new Error('useLinks must be used inside LinksContext.');
  }
  return linksEmbeddable;
};
exports.useLinks = useLinks;
const useLinksAttributes = () => {
  const linksEmbeddable = useLinks();
  const [attributes, setAttributes] = (0, _react.useState)(linksEmbeddable.attributes);
  (0, _react.useEffect)(() => {
    const attributesSubscription = linksEmbeddable.attributes$.subscribe(newAttributes => {
      setAttributes(newAttributes);
    });
    return () => {
      attributesSubscription.unsubscribe();
    };
  }, [linksEmbeddable.attributes$]);
  return attributes;
};
exports.useLinksAttributes = useLinksAttributes;