"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateUrl = void 0;
var _public = require("@kbn/ui-actions-enhanced-plugin/public");
var _kibana_services = require("../../services/kibana_services");
var _external_link_strings = require("./external_link_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 *
 * @param url The URl to validate
 * @returns Whether or not the URL is valid; if it is not, it will also return the reason it is invalid via the `message`
 */
const validateUrl = url => {
  try {
    /** This check will throw an error on invalid format, so catch it below */
    const allowedUrl = _kibana_services.coreServices.http.externalUrl.validateUrl(url);
    if (allowedUrl === null) {
      return {
        valid: false,
        message: _external_link_strings.ExternalLinkStrings.getDisallowedUrlError()
      };
    }
    const validatedUrl = (0, _public.urlDrilldownValidateUrl)(url);
    if (!validatedUrl.isValid) {
      throw new Error(); // will be caught below
    }
  } catch {
    return {
      valid: false,
      message: _external_link_strings.ExternalLinkStrings.getUrlFormatError()
    };
  }
  return {
    valid: true
  };
};
exports.validateUrl = validateUrl;