"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkDestination = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _content_management = require("../../../common/content_management");
var _external_link_destination_picker = require("../external_link/external_link_destination_picker");
var _dashboard_link_destination_picker = require("../dashboard_link/dashboard_link_destination_picker");
var _links_strings = require("../links_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LinkDestination = ({
  link,
  setDestination,
  parentDashboard,
  selectedLinkType
}) => {
  const [destinationError, setDestinationError] = (0, _react.useState)();

  /**
   * Store the dashboard / external destinations separately so that we can remember the selections
   * made in each component even when the selected link type changes
   */
  const [dashboardLinkDestination, setDashboardLinkDestination] = (0, _react.useState)(link && link.type === _content_management.DASHBOARD_LINK_TYPE ? link.destination : undefined);
  const [externalLinkDestination, setExternalLinkDestination] = (0, _react.useState)(link && link.type === _content_management.EXTERNAL_LINK_TYPE ? link.destination : undefined);
  const isInvalid = Boolean(destinationError);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: destinationError,
    isInvalid: isInvalid,
    label: _links_strings.LinksStrings.editor.linkEditor.getLinkDestinationLabel(),
    "data-test-subj": `links--linkDestination${isInvalid ? '--error' : ''}`
  }, selectedLinkType === _content_management.DASHBOARD_LINK_TYPE ? /*#__PURE__*/_react.default.createElement(_dashboard_link_destination_picker.DashboardLinkDestinationPicker, {
    onUnmount: selectedDashboardId => {
      setDestination(undefined, undefined);
      if (selectedDashboardId) setDashboardLinkDestination(selectedDashboardId);
    },
    parentDashboard: parentDashboard,
    initialSelection: dashboardLinkDestination,
    onDestinationPicked: dashboard => setDestination(dashboard === null || dashboard === void 0 ? void 0 : dashboard.id, dashboard === null || dashboard === void 0 ? void 0 : dashboard.attributes.title)
  }) : /*#__PURE__*/_react.default.createElement(_external_link_destination_picker.ExternalLinkDestinationPicker, {
    onUnmount: selectedUrl => {
      setDestinationError(undefined);
      setDestination(undefined, undefined);
      if (selectedUrl) setExternalLinkDestination(selectedUrl);
    },
    initialSelection: externalLinkDestination,
    onDestinationPicked: url => setDestination(url, url),
    setDestinationError: setDestinationError
  }));
};
exports.LinkDestination = LinkDestination;