"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizationTypes = exports.YAxisModes = exports.SeriesTypes = void 0;
var _i18n = require("@kbn/i18n");
var _chartIcons = require("@kbn/chart-icons");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const YAxisModes = exports.YAxisModes = {
  AUTO: 'auto',
  LEFT: 'left',
  RIGHT: 'right',
  BOTTOM: 'bottom'
};
const SeriesTypes = exports.SeriesTypes = {
  BAR: 'bar',
  LINE: 'line',
  AREA: 'area',
  BAR_STACKED: 'bar_stacked',
  AREA_STACKED: 'area_stacked',
  BAR_HORIZONTAL: 'bar_horizontal',
  BAR_PERCENTAGE_STACKED: 'bar_percentage_stacked',
  BAR_HORIZONTAL_STACKED: 'bar_horizontal_stacked',
  AREA_PERCENTAGE_STACKED: 'area_percentage_stacked',
  BAR_HORIZONTAL_PERCENTAGE_STACKED: 'bar_horizontal_percentage_stacked'
};

// Persisted parts of the state

const groupLabelForBar = _i18n.i18n.translate('xpack.lens.xyVisualization.barGroupLabel', {
  defaultMessage: 'Bar'
});
const groupLabelForLineAndArea = _i18n.i18n.translate('xpack.lens.xyVisualization.lineGroupLabel', {
  defaultMessage: 'Line and area'
});
const visualizationTypes = exports.visualizationTypes = [{
  id: 'bar',
  icon: _chartIcons.IconChartBar,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.barLabel', {
    defaultMessage: 'Bar vertical'
  }),
  groupLabel: groupLabelForBar,
  sortPriority: 4
}, {
  id: 'bar_horizontal',
  icon: _chartIcons.IconChartBarHorizontal,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.barHorizontalLabel', {
    defaultMessage: 'H. Bar'
  }),
  fullLabel: _i18n.i18n.translate('xpack.lens.xyVisualization.barHorizontalFullLabel', {
    defaultMessage: 'Bar horizontal'
  }),
  groupLabel: groupLabelForBar
}, {
  id: 'bar_stacked',
  icon: _chartIcons.IconChartBarStacked,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedBarLabel', {
    defaultMessage: 'Bar vertical stacked'
  }),
  groupLabel: groupLabelForBar
}, {
  id: 'bar_percentage_stacked',
  icon: _chartIcons.IconChartBarPercentage,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedPercentageBarLabel', {
    defaultMessage: 'Bar vertical percentage'
  }),
  groupLabel: groupLabelForBar
}, {
  id: 'bar_horizontal_stacked',
  icon: _chartIcons.IconChartBarHorizontalStacked,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedBarHorizontalLabel', {
    defaultMessage: 'H. Stacked bar'
  }),
  fullLabel: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedBarHorizontalFullLabel', {
    defaultMessage: 'Bar horizontal stacked'
  }),
  groupLabel: groupLabelForBar
}, {
  id: 'bar_horizontal_percentage_stacked',
  icon: _chartIcons.IconChartBarHorizontalPercentage,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedPercentageBarHorizontalLabel', {
    defaultMessage: 'H. Percentage bar'
  }),
  fullLabel: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedPercentageBarHorizontalFullLabel', {
    defaultMessage: 'Bar horizontal percentage'
  }),
  groupLabel: groupLabelForBar
}, {
  id: 'area',
  icon: _chartIcons.IconChartArea,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.areaLabel', {
    defaultMessage: 'Area'
  }),
  groupLabel: groupLabelForLineAndArea
}, {
  id: 'area_stacked',
  icon: _chartIcons.IconChartAreaStacked,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedAreaLabel', {
    defaultMessage: 'Area stacked'
  }),
  groupLabel: groupLabelForLineAndArea
}, {
  id: 'area_percentage_stacked',
  icon: _chartIcons.IconChartAreaPercentage,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedPercentageAreaLabel', {
    defaultMessage: 'Area percentage'
  }),
  groupLabel: groupLabelForLineAndArea
}, {
  id: 'line',
  icon: _chartIcons.IconChartLine,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.lineLabel', {
    defaultMessage: 'Line'
  }),
  groupLabel: groupLabelForLineAndArea,
  sortPriority: 2
}];