"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddLayerButton = AddLayerButton;
exports.AddLayerPanelType = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/expression-xy-plugin/public");
var _load_annotation_library_flyout = require("./load_annotation_library_flyout");
var _types = require("./types");
var _state_helpers = require("./state_helpers");
var _visualization_helpers = require("./visualization_helpers");
var _shared_components = require("../../shared_components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AddLayerPanelType = exports.AddLayerPanelType = /*#__PURE__*/function (AddLayerPanelType) {
  AddLayerPanelType["main"] = "main";
  AddLayerPanelType["selectAnnotationMethod"] = "selectAnnotationMethod";
  AddLayerPanelType["selectVisualizationType"] = "selectVisualizationType";
  return AddLayerPanelType;
}({});
function AddLayerButton({
  state,
  supportedLayers,
  addLayer,
  eventAnnotationService,
  isInlineEditing
}) {
  const [showLayersChoice, toggleLayersChoice] = (0, _react.useState)(false);
  const [isLoadLibraryVisible, setLoadLibraryFlyoutVisible] = (0, _react.useState)(false);
  const annotationPanel = ({
    type,
    label,
    icon,
    disabled,
    toolTipContent
  }) => {
    return {
      panel: AddLayerPanelType.selectAnnotationMethod,
      toolTipContent,
      disabled,
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        responsive: false,
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "lnsLayerAddButton__label"
      }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_shared_components.ExperimentalBadge, {
        color: disabled ? 'subdued' : undefined
      }))),
      className: 'lnsLayerAddButton',
      icon: icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: icon
      }),
      ['data-test-subj']: `lnsLayerAddButton-${type}`
    };
  };
  const dataPanel = ({
    type,
    label,
    icon,
    disabled,
    toolTipContent
  }) => {
    return {
      panel: AddLayerPanelType.selectVisualizationType,
      toolTipContent,
      disabled,
      name: /*#__PURE__*/_react.default.createElement("span", {
        className: "lnsLayerAddButtonLabel"
      }, label),
      className: 'lnsLayerAddButton',
      icon: icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: icon
      }),
      ['data-test-subj']: `lnsLayerAddButton-${type}`
    };
  };
  const horizontalOnly = (0, _state_helpers.isHorizontalChart)(state.layers);
  const availableVisTypes = _types.visualizationTypes.filter(t => (0, _state_helpers.isHorizontalSeries)(t.id) === horizontalOnly);
  const currentLayerVisType = availableVisTypes.findIndex(t => {
    var _getDataLayers, _getDataLayers$;
    return t.id === ((_getDataLayers = (0, _visualization_helpers.getDataLayers)(state.layers)) === null || _getDataLayers === void 0 ? void 0 : (_getDataLayers$ = _getDataLayers[0]) === null || _getDataLayers$ === void 0 ? void 0 : _getDataLayers$.seriesType);
  }) || 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    display: "block",
    "data-test-subj": "lnsConfigPanel__addLayerPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fullWidth: true,
      "data-test-subj": "lnsLayerAddButton",
      "aria-label": _i18n.i18n.translate('xpack.lens.configPanel.addLayerButton', {
        defaultMessage: 'Add layer'
      }),
      fill: true,
      color: "text",
      onClick: () => toggleLayersChoice(!showLayersChoice),
      iconType: "layers"
    }, _i18n.i18n.translate('xpack.lens.configPanel.addLayerButton', {
      defaultMessage: 'Add layer'
    })),
    isOpen: showLayersChoice,
    closePopover: () => toggleLayersChoice(false),
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: AddLayerPanelType.main,
    size: "s",
    panels: [{
      id: AddLayerPanelType.main,
      title: _i18n.i18n.translate('xpack.lens.configPanel.selectLayerType', {
        defaultMessage: 'Select layer type'
      }),
      width: 300,
      items: supportedLayers.map(props => {
        const {
          type,
          label,
          icon,
          disabled,
          toolTipContent
        } = props;
        if (type === _public.LayerTypes.ANNOTATIONS) {
          return annotationPanel(props);
        } else if (type === _public.LayerTypes.DATA) {
          return dataPanel(props);
        }
        return {
          toolTipContent,
          disabled,
          name: /*#__PURE__*/_react.default.createElement("span", {
            className: "lnsLayerAddButtonLabel"
          }, label),
          className: 'lnsLayerAddButton',
          icon: icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            size: "m",
            type: icon
          }),
          ['data-test-subj']: `lnsLayerAddButton-${type}`,
          onClick: () => {
            addLayer(type);
            toggleLayersChoice(false);
          }
        };
      })
    }, {
      id: AddLayerPanelType.selectAnnotationMethod,
      initialFocusedItemIndex: 0,
      title: _i18n.i18n.translate('xpack.lens.configPanel.selectAnnotationMethod', {
        defaultMessage: 'Select annotation method'
      }),
      items: [{
        name: _i18n.i18n.translate('xpack.lens.configPanel.newAnnotation', {
          defaultMessage: 'New annotation'
        }),
        icon: 'plusInCircle',
        onClick: () => {
          addLayer(_public.LayerTypes.ANNOTATIONS);
          toggleLayersChoice(false);
        },
        'data-test-subj': 'lnsAnnotationLayer_new'
      }, {
        name: _i18n.i18n.translate('xpack.lens.configPanel.loadFromLibrary', {
          defaultMessage: 'Load from library'
        }),
        icon: 'folderOpen',
        onClick: () => {
          setLoadLibraryFlyoutVisible(true);
          toggleLayersChoice(false);
        },
        'data-test-subj': 'lnsAnnotationLayer_addFromLibrary'
      }]
    }, {
      id: AddLayerPanelType.selectVisualizationType,
      initialFocusedItemIndex: currentLayerVisType,
      title: _i18n.i18n.translate('xpack.lens.layerPanel.selectVisualizationType', {
        defaultMessage: 'Select visualization type'
      }),
      items: availableVisTypes.map(t => ({
        name: t.fullLabel || t.label,
        icon: t.icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "m",
          type: t.icon
        }),
        onClick: () => {
          addLayer(_public.LayerTypes.DATA, undefined, undefined, t.id);
          toggleLayersChoice(false);
        },
        'data-test-subj': `lnsXY_seriesType-${t.id}`
      }))
    }]
  })), isLoadLibraryVisible && /*#__PURE__*/_react.default.createElement(_load_annotation_library_flyout.LoadAnnotationLibraryFlyout, {
    isLoadLibraryVisible: isLoadLibraryVisible,
    setLoadLibraryFlyoutVisible: setLoadLibraryFlyoutVisible,
    eventAnnotationService: eventAnnotationService,
    isInlineEditing: isInlineEditing,
    addLayer: extraArg => {
      addLayer(_public.LayerTypes.ANNOTATIONS, extraArg);
    }
  }));
}