"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToRuntime = convertToRuntime;
var _charts = require("@elastic/charts");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertToRuntime(state) {
  let newState = (0, _lodash.cloneDeep)(state);
  newState = convertToLegendStats(newState);
  return newState;
}
function convertToLegendStats(state) {
  state.layers.forEach(l => {
    if ('showValuesInLegend' in l) {
      l.legendStats = [...new Set([...(l.showValuesInLegend ? [_charts.LegendValue.Value] : []), ...(l.legendStats || [])])];
    }
    delete l.showValuesInLegend;
  });
  return state;
}