"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PartitionChartsMeta = void 0;
var _i18n = require("@kbn/i18n");
var _chartIcons = require("@kbn/chart-icons");
var _charts = require("@elastic/charts");
var _types = require("../../../common/types");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const groupLabel = _i18n.i18n.translate('xpack.lens.pie.groupLabel', {
  defaultMessage: 'Proportion'
});
const categoryOptions = [{
  value: _constants.CategoryDisplay.DEFAULT,
  inputDisplay: _i18n.i18n.translate('xpack.lens.pieChart.showCategoriesLabel', {
    defaultMessage: 'Inside or outside'
  })
}, {
  value: _constants.CategoryDisplay.INSIDE,
  inputDisplay: _i18n.i18n.translate('xpack.lens.pieChart.fitInsideOnlyLabel', {
    defaultMessage: 'Inside only'
  })
}, {
  value: _constants.CategoryDisplay.HIDE,
  inputDisplay: _i18n.i18n.translate('xpack.lens.pieChart.categoriesInLegendLabel', {
    defaultMessage: 'Hide labels'
  })
}];
const categoryOptionsTreemap = [{
  value: _constants.CategoryDisplay.DEFAULT,
  inputDisplay: _i18n.i18n.translate('xpack.lens.pieChart.showTreemapCategoriesLabel', {
    defaultMessage: 'Show labels'
  })
}, {
  value: _constants.CategoryDisplay.HIDE,
  inputDisplay: _i18n.i18n.translate('xpack.lens.pieChart.categoriesInLegendLabel', {
    defaultMessage: 'Hide labels'
  })
}];
const numberOptions = [{
  value: _constants.NumberDisplay.HIDDEN,
  inputDisplay: _i18n.i18n.translate('xpack.lens.pieChart.hiddenNumbersLabel', {
    defaultMessage: 'Hide from chart'
  })
}, {
  value: _constants.NumberDisplay.PERCENT,
  inputDisplay: _i18n.i18n.translate('xpack.lens.pieChart.showPercentValuesLabel', {
    defaultMessage: 'Show percent'
  })
}, {
  value: _constants.NumberDisplay.VALUE,
  inputDisplay: _i18n.i18n.translate('xpack.lens.pieChart.showFormatterValuesLabel', {
    defaultMessage: 'Show value'
  })
}];
const emptySizeRatioOptions = [{
  id: 'emptySizeRatioOption-small',
  value: _types.EmptySizeRatios.SMALL,
  label: _i18n.i18n.translate('xpack.lens.pieChart.emptySizeRatioOptions.small', {
    defaultMessage: 'Small'
  })
}, {
  id: 'emptySizeRatioOption-medium',
  value: _types.EmptySizeRatios.MEDIUM,
  label: _i18n.i18n.translate('xpack.lens.pieChart.emptySizeRatioOptions.medium', {
    defaultMessage: 'Medium'
  })
}, {
  id: 'emptySizeRatioOption-large',
  value: _types.EmptySizeRatios.LARGE,
  label: _i18n.i18n.translate('xpack.lens.pieChart.emptySizeRatioOptions.large', {
    defaultMessage: 'Large'
  })
}];
const PartitionChartsMeta = exports.PartitionChartsMeta = {
  donut: {
    icon: _chartIcons.IconChartDonut,
    label: _i18n.i18n.translate('xpack.lens.pie.donutLabel', {
      defaultMessage: 'Donut'
    }),
    groupLabel,
    maxBuckets: 3,
    toolbarPopover: {
      categoryOptions,
      numberOptions,
      emptySizeRatioOptions
    },
    legend: {
      getShowLegendDefault: bucketColumns => bucketColumns.length > 1
    }
  },
  pie: {
    icon: _chartIcons.IconChartPie,
    label: _i18n.i18n.translate('xpack.lens.pie.pielabel', {
      defaultMessage: 'Pie'
    }),
    groupLabel,
    maxBuckets: 3,
    toolbarPopover: {
      categoryOptions,
      numberOptions
    },
    legend: {
      getShowLegendDefault: bucketColumns => bucketColumns.length > 1
    }
  },
  treemap: {
    icon: _chartIcons.IconChartTreemap,
    label: _i18n.i18n.translate('xpack.lens.pie.treemaplabel', {
      defaultMessage: 'Treemap'
    }),
    groupLabel,
    maxBuckets: 2,
    toolbarPopover: {
      categoryOptions: categoryOptionsTreemap,
      numberOptions
    },
    legend: {
      getShowLegendDefault: () => false
    }
  },
  mosaic: {
    icon: _chartIcons.IconChartMosaic,
    label: _i18n.i18n.translate('xpack.lens.pie.mosaiclabel', {
      defaultMessage: 'Mosaic'
    }),
    groupLabel,
    maxBuckets: 2,
    toolbarPopover: {
      categoryOptions: [],
      numberOptions
    },
    legend: {
      getShowLegendDefault: () => false
    }
  },
  waffle: {
    icon: _chartIcons.IconChartWaffle,
    label: _i18n.i18n.translate('xpack.lens.pie.wafflelabel', {
      defaultMessage: 'Waffle'
    }),
    groupLabel,
    maxBuckets: 1,
    toolbarPopover: {
      isDisabled: true,
      categoryOptions: [],
      numberOptions: []
    },
    legend: {
      flat: true,
      defaultLegendStats: [_charts.LegendValue.Value],
      hideNestedLegendSwitch: true,
      getShowLegendDefault: () => true
    }
  }
};