"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpression = void 0;
var _coloring = require("@kbn/coloring");
var _common = require("@kbn/expressions-plugin/common");
var _charts = require("@elastic/charts");
var _metric_visualization = require("./metric_visualization");
var _visualization = require("./visualization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO - deduplicate with gauges?
function computePaletteParams(params) {
  return {
    ...params,
    // rewrite colors and stops as two distinct arguments
    colors: ((params === null || params === void 0 ? void 0 : params.stops) || []).map(({
      color
    }) => color),
    stops: (params === null || params === void 0 ? void 0 : params.name) === 'custom' ? ((params === null || params === void 0 ? void 0 : params.stops) || []).map(({
      stop
    }) => stop) : [],
    reverse: false // managed at UI level
  };
}
const getTrendlineExpression = (state, datasourceExpressionsByLayers) => {
  const {
    trendlineLayerId,
    trendlineMetricAccessor,
    trendlineTimeAccessor
  } = state;
  if (!trendlineLayerId || !trendlineMetricAccessor || !trendlineTimeAccessor) {
    return;
  }
  const datasourceExpression = datasourceExpressionsByLayers[trendlineLayerId];
  if (!datasourceExpression) {
    return;
  }
  const metricTrendlineFn = (0, _common.buildExpressionFunction)('metricTrendline', {
    metric: trendlineMetricAccessor,
    timeField: trendlineTimeAccessor,
    breakdownBy: state.trendlineBreakdownByAccessor && !state.collapseFn ? state.trendlineBreakdownByAccessor : undefined,
    inspectorTableId: trendlineLayerId,
    table: [{
      ...datasourceExpression,
      chain: [...datasourceExpression.chain, ...(state.collapseFn ? [(0, _common.buildExpressionFunction)('lens_collapse', {
        by: [trendlineTimeAccessor],
        metric: [trendlineMetricAccessor],
        fn: [state.collapseFn]
      }).toAst()] : [])]
    }]
  });
  return (0, _common.buildExpression)([metricTrendlineFn]).toAst();
};
const toExpression = (paletteService, state, datasourceLayers, datasourceExpressionsByLayers = {}) => {
  var _datasource$getOperat, _state$subtitle, _state$palette, _state$maxCols, _datasourceExpression;
  if (!state.metricAccessor) {
    return null;
  }
  const datasource = datasourceLayers[state.layerId];
  const datasourceExpression = datasourceExpressionsByLayers[state.layerId];
  const isMetricNumeric = Boolean(state.metricAccessor && (datasource === null || datasource === void 0 ? void 0 : (_datasource$getOperat = datasource.getOperationForColumnId(state.metricAccessor)) === null || _datasource$getOperat === void 0 ? void 0 : _datasource$getOperat.dataType) === 'number');
  const maxPossibleTiles =
  // if there's a collapse function, no need to calculate since we're dealing with a single tile
  state.breakdownByAccessor && !state.collapseFn ? datasource === null || datasource === void 0 ? void 0 : datasource.getMaxPossibleNumValues(state.breakdownByAccessor) : null;
  const getCollapseFnArguments = () => {
    const metric = [state.metricAccessor, state.secondaryMetricAccessor, state.maxAccessor].filter(Boolean);
    const collapseFn = state.collapseFn;
    const fn = metric.map(accessor => {
      if (accessor !== state.maxAccessor) {
        return collapseFn;
      } else {
        var _datasource$getOperat2;
        const isMaxStatic = Boolean(datasource === null || datasource === void 0 ? void 0 : (_datasource$getOperat2 = datasource.getOperationForColumnId(state.maxAccessor)) === null || _datasource$getOperat2 === void 0 ? void 0 : _datasource$getOperat2.isStaticValue);
        // we do this because the user expects the static value they set to be the same
        // even if they define a collapse on the breakdown by
        return isMaxStatic ? 'max' : collapseFn;
      }
    });
    return {
      by: [],
      metric,
      fn
    };
  };
  const collapseExpressionFunction = state.collapseFn ? (0, _common.buildExpressionFunction)('lens_collapse', getCollapseFnArguments()).toAst() : undefined;
  const trendlineExpression = getTrendlineExpression(state, datasourceExpressionsByLayers);
  const metricFn = (0, _common.buildExpressionFunction)('metricVis', {
    metric: state.metricAccessor,
    secondaryMetric: state.secondaryMetricAccessor,
    secondaryPrefix: state.secondaryPrefix,
    max: state.maxAccessor,
    breakdownBy: state.breakdownByAccessor && !state.collapseFn ? state.breakdownByAccessor : undefined,
    trendline: trendlineExpression ? [trendlineExpression] : [],
    subtitle: (_state$subtitle = state.subtitle) !== null && _state$subtitle !== void 0 ? _state$subtitle : undefined,
    progressDirection: (0, _metric_visualization.showingBar)(state) ? state.progressDirection || _charts.LayoutDirection.Vertical : undefined,
    color: state.color || (0, _visualization.getDefaultColor)(state, isMetricNumeric),
    icon: state.icon,
    palette: isMetricNumeric && (_state$palette = state.palette) !== null && _state$palette !== void 0 && _state$palette.params ? [paletteService.get(_coloring.CUSTOM_PALETTE).toExpression(computePaletteParams(state.palette.params))] : [],
    maxCols: (_state$maxCols = state.maxCols) !== null && _state$maxCols !== void 0 ? _state$maxCols : _visualization.DEFAULT_MAX_COLUMNS,
    minTiles: maxPossibleTiles !== null && maxPossibleTiles !== void 0 ? maxPossibleTiles : undefined,
    inspectorTableId: state.layerId
  });
  return {
    type: 'expression',
    chain: [...((_datasourceExpression = datasourceExpression === null || datasourceExpression === void 0 ? void 0 : datasourceExpression.chain) !== null && _datasourceExpression !== void 0 ? _datasourceExpression : []), ...(collapseExpressionFunction ? [collapseExpressionFunction] : []), metricFn.toAst()]
  };
};
exports.toExpression = toExpression;