"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataTableToolbar = DataTableToolbar;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _shared_components = require("../../../shared_components");
var _types = require("../../../../common/types");
var _table_basic = require("./table_basic");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DataTableToolbar(props) {
  var _state$headerRowHeigh, _state$headerRowHeigh2, _state$paging2;
  const {
    state,
    setState
  } = props;
  const onChangeHeight = (0, _react.useCallback)((newHeightMode, heightProperty, heightLinesProperty, defaultRowHeight = _constants.DEFAULT_ROW_HEIGHT_LINES) => {
    const rowHeightLines = newHeightMode === _types.RowHeightMode.single ? 1 : newHeightMode !== _types.RowHeightMode.auto ? defaultRowHeight : undefined;
    setState({
      ...state,
      [heightProperty]: newHeightMode,
      [heightLinesProperty]: rowHeightLines
    });
  }, [setState, state]);
  const onChangeHeightLines = (0, _react.useCallback)((newRowHeightLines, heightLinesProperty) => {
    setState({
      ...state,
      [heightLinesProperty]: newRowHeightLines
    });
  }, [setState, state]);
  const onTogglePagination = (0, _react.useCallback)(() => {
    var _state$paging;
    const current = (_state$paging = state.paging) !== null && _state$paging !== void 0 ? _state$paging : {
      size: _table_basic.DEFAULT_PAGE_SIZE,
      enabled: false
    };
    setState({
      ...state,
      paging: {
        ...current,
        enabled: !current.enabled
      }
    });
  }, [setState, state]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.table.valuesVisualOptions', {
      defaultMessage: 'Visual options'
    }),
    type: "visualOptions",
    groupPosition: "none",
    buttonDataTestSubj: "lnsVisualOptionsButton"
  }, /*#__PURE__*/_react.default.createElement(_unifiedDataTable.RowHeightSettings, {
    rowHeight: (_state$headerRowHeigh = state.headerRowHeight) !== null && _state$headerRowHeigh !== void 0 ? _state$headerRowHeigh : _constants.DEFAULT_HEADER_ROW_HEIGHT,
    rowHeightLines: (_state$headerRowHeigh2 = state.headerRowHeightLines) !== null && _state$headerRowHeigh2 !== void 0 ? _state$headerRowHeigh2 : _constants.DEFAULT_HEADER_ROW_HEIGHT_LINES,
    label: _i18n.i18n.translate('xpack.lens.table.visualOptionsHeaderRowHeightLabel', {
      defaultMessage: 'Header row height'
    }),
    onChangeRowHeight: mode => onChangeHeight(mode, 'headerRowHeight', 'headerRowHeightLines', _constants.DEFAULT_HEADER_ROW_HEIGHT_LINES),
    onChangeRowHeightLines: lines => {
      onChangeHeightLines(lines, 'headerRowHeightLines');
    },
    "data-test-subj": "lnsHeaderHeightSettings",
    maxRowHeight: 5,
    compressed: true
  }), /*#__PURE__*/_react.default.createElement(_unifiedDataTable.RowHeightSettings, {
    rowHeight: state.rowHeight,
    rowHeightLines: state.rowHeightLines,
    label: _i18n.i18n.translate('xpack.lens.table.visualOptionsFitRowToContentLabel', {
      defaultMessage: 'Cell row height'
    }),
    onChangeRowHeight: mode => onChangeHeight(mode, 'rowHeight', 'rowHeightLines'),
    onChangeRowHeightLines: lines => {
      onChangeHeightLines(lines, 'rowHeightLines');
    },
    "data-test-subj": "lnsRowHeightSettings",
    compressed: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.table.visualOptionsPaginateTable', {
      defaultMessage: 'Paginate table'
    }),
    display: "columnCompressedSwitch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.lens.table.visualOptionsPaginateTableTooltip', {
      defaultMessage: 'Pagination is hidden if there are less than 10 items'
    }),
    position: "right"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "lens-table-pagination-switch",
    label: "",
    showLabel: false,
    checked: Boolean((_state$paging2 = state.paging) === null || _state$paging2 === void 0 ? void 0 : _state$paging2.enabled),
    onChange: onTogglePagination
  })))));
}