"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGridCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _transpose_helpers = require("../../../../common/expressions/datatable/transpose_helpers");
var _utils = require("../../../shared_components/coloring/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createGridCell = (formatters, columnConfig, DataContext, theme, fitRowToContent) => {
  return ({
    rowIndex,
    columnId,
    setCellProps
  }) => {
    var _table$rows$rowIndex, _formatters$columnId;
    const {
      table,
      alignments,
      minMaxByColumnId,
      getColorForValue,
      handleFilterClick
    } = (0, _react.useContext)(DataContext);
    const IS_DARK_THEME = (0, _useObservable.default)(theme.theme$, {
      darkMode: false
    }).darkMode;
    const rowValue = table === null || table === void 0 ? void 0 : (_table$rows$rowIndex = table.rows[rowIndex]) === null || _table$rows$rowIndex === void 0 ? void 0 : _table$rows$rowIndex[columnId];
    const colIndex = columnConfig.columns.findIndex(({
      columnId: id
    }) => id === columnId);
    const {
      colorMode,
      palette,
      oneClickFilter
    } = columnConfig.columns[colIndex] || {};
    const filterOnClick = oneClickFilter && handleFilterClick;
    const content = (_formatters$columnId = formatters[columnId]) === null || _formatters$columnId === void 0 ? void 0 : _formatters$columnId.convert(rowValue, filterOnClick ? 'text' : 'html');
    const currentAlignment = alignments && alignments[columnId];
    (0, _react.useEffect)(() => {
      const originalId = (0, _transpose_helpers.getOriginalId)(columnId);
      if (minMaxByColumnId !== null && minMaxByColumnId !== void 0 && minMaxByColumnId[originalId]) {
        if (colorMode !== 'none' && palette !== null && palette !== void 0 && palette.params && getColorForValue) {
          // workout the bucket the value belongs to
          const color = getColorForValue((0, _utils.getNumericValue)(rowValue), palette.params, minMaxByColumnId[originalId]);
          if (color) {
            const style = {
              [colorMode === 'cell' ? 'backgroundColor' : 'color']: color
            };
            if (colorMode === 'cell' && color) {
              style.color = (0, _utils.getContrastColor)(color, IS_DARK_THEME);
            }
            setCellProps({
              style
            });
          }
        }
      }
      // make sure to clean it up when something change
      // this avoids cell's styling to stick forever
      return () => {
        if (minMaxByColumnId !== null && minMaxByColumnId !== void 0 && minMaxByColumnId[originalId]) {
          setCellProps({
            style: {
              backgroundColor: undefined,
              color: undefined
            }
          });
        }
      };
    }, [rowValue, columnId, setCellProps, colorMode, palette, minMaxByColumnId, getColorForValue, IS_DARK_THEME]);
    if (filterOnClick) {
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "lnsTableCellContent",
        className: (0, _classnames.default)({
          'lnsTableCell--multiline': fitRowToContent,
          [`lnsTableCell--${currentAlignment}`]: true
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => {
          handleFilterClick === null || handleFilterClick === void 0 ? void 0 : handleFilterClick(columnId, rowValue, colIndex, rowIndex);
        }
      }, content));
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      /*
       * dangerouslySetInnerHTML is necessary because the field formatter might produce HTML markup
       * which is produced in a safe way.
       */
      dangerouslySetInnerHTML: {
        __html: content
      } // eslint-disable-line react/no-danger
      ,
      "data-test-subj": "lnsTableCellContent",
      className: (0, _classnames.default)({
        'lnsTableCell--multiline': fitRowToContent,
        [`lnsTableCell--${currentAlignment}`]: true
      })
    });
  };
};
exports.createGridCell = createGridCell;